SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[HMS_User](
	[UserId] [bigint] IDENTITY(1,1) NOT NULL,
	[FirstName] [varchar](50) NOT NULL,
	[MiddleName] [varchar](50) NULL,
	[LastName] [varchar](50) NOT NULL,
	[Email] [varchar](100) NOT NULL,
	[Phone] [varchar](20) NOT NULL,
	[Password] [varchar](50) NOT NULL,
	[CompanyId] [bigint] NULL,
	[RoleId] [bigint] NULL,
	[Address1] [nvarchar](500) NULL,
	[Address2] [nvarchar](500) NULL,
	[City] [nvarchar](50) NULL,
	[State] [nvarchar](50) NULL,
	[ZipCode] [nvarchar](20) NULL,
	[Country] [nvarchar](50) NULL,
	[ProfilePic] [nvarchar](200) NULL,
	[IsActive] [bit] NULL,
	[IsDeleted] [bit] NULL,
	[CreatedDate] [datetime] NULL,
	[ModifiedDate] [datetime] NULL,
	[CreatedBy] [bigint] NULL,
 CONSTRAINT [PK_HMS_User] PRIMARY KEY CLUSTERED 
(
	[UserId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[HMS_Unit](
	[UnitId] [bigint] IDENTITY(1,1) NOT NULL,
	[UnitName] [nvarchar](50) NULL,
	[IsActive] [bit] NULL,
	[IsDeleted] [bit] NULL,
	[CreatedDate] [datetime] NULL,
	[ModifiedDate] [datetime] NULL,
	[CreatedBy] [bigint] NULL,
	[ModifiedBy] [bigint] NULL,
 CONSTRAINT [PK_HMS_Unit] PRIMARY KEY CLUSTERED 
(
	[UnitId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[HMS_Treatment](
	[TreatmentId] [bigint] IDENTITY(1,1) NOT NULL,
	[TreatmentName] [nvarchar](100) NULL,
	[Description] [nvarchar](1000) NULL,
	[TreatmentCost] [money] NULL,
	[IsActive] [bit] NULL,
	[IsDeleted] [bit] NULL,
	[CreatedDate] [datetime] NULL,
	[ModifiedDate] [datetime] NULL,
	[CreatedBy] [bigint] NULL,
	[ModifiedBy] [bigint] NULL,
 CONSTRAINT [PK_HMS_Treatment] PRIMARY KEY CLUSTERED 
(
	[TreatmentId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[HMS_SiteMenuLTE](
	[MenuId] [bigint] NOT NULL,
	[ParentMenuId] [bigint] NULL,
	[MenuCode] [varchar](50) NULL,
	[MenuName] [varchar](50) NOT NULL,
	[MenuPageName] [varchar](50) NULL,
	[MenuImageName] [varchar](50) NULL,
	[MenuOrderNo] [int] NULL,
	[IsActive] [bit] NULL,
	[IsDeleted] [bit] NULL,
 CONSTRAINT [PK_HMS_SiteMenuLTE] PRIMARY KEY CLUSTERED 
(
	[MenuId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[HMS_Setting](
	[SettingId] [bigint] IDENTITY(1,1) NOT NULL,
	[SiteTitle] [varchar](100) NULL,
	[CopyrightText] [varchar](100) NULL,
	[AdminEmail] [varchar](50) NULL,
	[SupportEmail] [varchar](50) NULL,
	[ContactEmail] [varchar](50) NULL,
	[TollFreeNo] [varchar](20) NULL,
	[ContactNo] [varchar](20) NULL,
	[SMTPHost] [varchar](100) NULL,
	[SMTPPort] [int] NULL,
	[SMTPUserName] [varchar](50) NULL,
	[SMTPPassword] [varchar](50) NULL,
	[PageSize] [int] NULL,
 CONSTRAINT [PK_HMS_Setting] PRIMARY KEY CLUSTERED 
(
	[SettingId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[HMS_RoleSiteMenu](
	[RoleSiteMenuId] [bigint] IDENTITY(1,1) NOT NULL,
	[RoleId] [bigint] NOT NULL,
	[MenuId] [bigint] NOT NULL,
	[MenuCode] [varchar](50) NULL,
 CONSTRAINT [PK_HMS_RoleSiteMenu] PRIMARY KEY CLUSTERED 
(
	[RoleSiteMenuId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[HMS_Role](
	[RoleId] [bigint] IDENTITY(1,1) NOT NULL,
	[RoleName] [varchar](50) NULL,
 CONSTRAINT [PK_HMS_Role] PRIMARY KEY CLUSTERED 
(
	[RoleId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[HMS_Report](
	[ReportId] [bigint] IDENTITY(1,1) NOT NULL,
	[ReportTypeId] [bigint] NULL,
	[PatientId] [bigint] NULL,
	[CompanyId] [bigint] NULL,
	[Description] [nvarchar](2000) NULL,
	[ReportDate] [datetime] NULL,
	[ReportFile] [nvarchar](100) NULL,
	[IsDeleted] [bit] NULL,
	[CreatedDate] [datetime] NULL,
	[ModifiedDate] [datetime] NULL,
	[CreatedBy] [bigint] NULL,
	[ModifiedBy] [bigint] NULL,
 CONSTRAINT [PK_HMS_Report] PRIMARY KEY CLUSTERED 
(
	[ReportId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[HMS_PrescriptionDetail](
	[PrescriptionDetailId] [bigint] IDENTITY(1,1) NOT NULL,
	[PrescriptionId] [bigint] NULL,
	[PatientId] [bigint] NULL,
	[MedicineId] [bigint] NULL,
	[NoOfDays] [int] NULL,
	[WhenToTake] [nvarchar](20) NULL,
	[IsBeforeMeal] [bit] NULL,
 CONSTRAINT [PK_HMS_PrescriptionDetail] PRIMARY KEY CLUSTERED 
(
	[PrescriptionDetailId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[HMS_Prescription](
	[PrescriptionId] [bigint] IDENTITY(1,1) NOT NULL,
	[PatientCheckupId] [bigint] NULL,
	[PatientId] [bigint] NULL,
	[TreatmentId] [bigint] NULL,
	[CaseHistory] [nvarchar](max) NULL,
	[ExtraNotes] [nvarchar](max) NULL,
	[PrescriptionDate] [datetime] NULL,
 CONSTRAINT [PK_HMS_Prescription] PRIMARY KEY CLUSTERED 
(
	[PrescriptionId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[HMS_PaymentDetail](
	[PaymentDetailId] [bigint] IDENTITY(1,1) NOT NULL,
	[PaymentId] [bigint] NULL,
	[PaymentCategoryId] [bigint] NULL,
	[PaymentAmount] [money] NULL,
 CONSTRAINT [PK_HMS_PaymentDetail] PRIMARY KEY CLUSTERED 
(
	[PaymentDetailId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[HMS_PaymentCategory](
	[PaymentCategoryId] [bigint] IDENTITY(1,1) NOT NULL,
	[PaymentCategory] [nvarchar](100) NULL,
	[CompanyId] [bigint] NULL,
	[Description] [nvarchar](500) NULL,
	[IsActive] [bit] NULL,
	[IsDeleted] [bit] NULL,
	[CreatedDate] [datetime] NULL,
	[ModifiedDate] [datetime] NULL,
	[CreatedBy] [bigint] NULL,
	[ModifiedBy] [bigint] NULL,
 CONSTRAINT [PK_HMS_PaymentCategory] PRIMARY KEY CLUSTERED 
(
	[PaymentCategoryId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[HMS_Payment](
	[PaymentId] [bigint] IDENTITY(1,1) NOT NULL,
	[InvoiceNumber] [nvarchar](10) NULL,
	[PatientId] [bigint] NULL,
	[CompanyId] [bigint] NULL,
	[PaymentDate] [datetime] NULL,
	[SubTotal] [money] NULL,
	[Discount] [money] NULL,
	[Tax] [money] NULL,
	[GrandTotal] [money] NULL,
	[PaymentStatus] [int] NULL,
	[IsDeleted] [bit] NULL,
	[CreatedDate] [datetime] NULL,
	[ModifiedDate] [datetime] NULL,
	[CreatedBy] [bigint] NULL,
	[ModifiedBy] [bigint] NULL,
 CONSTRAINT [PK_HMS_Payment] PRIMARY KEY CLUSTERED 
(
	[PaymentId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[HMS_PatientTestDetail](
	[PatientTestDetailId] [bigint] IDENTITY(1,1) NOT NULL,
	[PatientTestId] [bigint] NULL,
	[LabTestId] [bigint] NULL,
	[Result] [nchar](10) NULL,
	[Remarks] [nvarchar](100) NULL,
 CONSTRAINT [PK_HMS_PatientTestDetail] PRIMARY KEY CLUSTERED 
(
	[PatientTestDetailId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[HMS_PatientTest](
	[PatientTestId] [bigint] IDENTITY(1,1) NOT NULL,
	[CompanyId] [bigint] NULL,
	[PatientId] [bigint] NULL,
	[ConsultantId] [bigint] NULL,
	[DeliveryDate] [datetime] NULL,
	[TestDate] [datetime] NULL,
	[ReportStatus] [int] NULL,
	[IsDeleted] [bit] NULL,
	[CreatedDate] [datetime] NULL,
	[ModifiedDate] [datetime] NULL,
	[CreatedBy] [bigint] NULL,
	[ModifiedBy] [bigint] NULL,
 CONSTRAINT [PK_HMS_PatientTest] PRIMARY KEY CLUSTERED 
(
	[PatientTestId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[HMS_PatientDetail](
	[PatientId] [bigint] IDENTITY(1,1) NOT NULL,
	[PatientCode] [nvarchar](20) NULL,
	[UserId] [bigint] NULL,
	[PatientType] [tinyint] NULL,
	[BirthDate] [datetime] NULL,
	[Gender] [varchar](10) NULL,
	[BloodGroup] [nvarchar](10) NULL,
 CONSTRAINT [PK_HMS_PatientDetail] PRIMARY KEY CLUSTERED 
(
	[PatientId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1 - InPatient  2 - OutPatient' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'HMS_PatientDetail', @level2type=N'COLUMN',@level2name=N'PatientType'
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[HMS_PatientCheckup](
	[PatientCheckupId] [bigint] IDENTITY(1,1) NOT NULL,
	[PatientId] [bigint] NULL,
	[CheckupDate] [datetime] NULL,
	[DoctorId] [bigint] NULL,
	[Symptoms] [nvarchar](max) NULL,
	[Diagnosis] [nvarchar](max) NULL,
	[CreatedDate] [datetime] NULL,
	[CreatedBy] [bigint] NULL,
	[ModifiedDate] [datetime] NULL,
	[ModifiedBy] [bigint] NULL,
 CONSTRAINT [PK_HMS_PatientCheckup] PRIMARY KEY CLUSTERED 
(
	[PatientCheckupId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[HMS_MedicineCategory](
	[MedicineCategoryId] [bigint] IDENTITY(1,1) NOT NULL,
	[MedicineCategory] [nvarchar](100) NULL,
	[CompanyId] [bigint] NULL,
	[IsActive] [bit] NULL,
	[IsDeleted] [bit] NULL,
	[CreatedDate] [datetime] NULL,
	[ModifiedDate] [datetime] NULL,
	[CreatedBy] [bigint] NULL,
	[ModifiedBy] [bigint] NULL,
 CONSTRAINT [PK_HMS_MedicineCategory] PRIMARY KEY CLUSTERED 
(
	[MedicineCategoryId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[HMS_Medicine](
	[MedicineId] [bigint] IDENTITY(1,1) NOT NULL,
	[CompanyId] [bigint] NULL,
	[MedicineName] [nvarchar](200) NULL,
	[Description] [nvarchar](1000) NULL,
	[MedicineCategoryId] [bigint] NULL,
	[CostPrice] [money] NULL,
	[SalePrice] [money] NULL,
	[AvailableQuantity] [int] NULL,
	[UnitId] [bigint] NULL,
	[HMS_Company] [nvarchar](100) NULL,
	[IsActive] [bit] NULL,
	[IsDeleted] [bit] NULL,
	[CreatedDate] [datetime] NULL,
	[ModifiedDate] [datetime] NULL,
	[CreatedBy] [bigint] NULL,
	[ModifiedBy] [bigint] NULL,
 CONSTRAINT [PK_HMS_Medicine] PRIMARY KEY CLUSTERED 
(
	[MedicineId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[HMS_LoginHistory](
	[LoginHistoryId] [bigint] IDENTITY(1,1) NOT NULL,
	[UserId] [bigint] NOT NULL,
	[Action] [tinyint] NULL,
	[IpAddress] [varchar](20) NULL,
	[ActionDate] [datetime] NOT NULL,
 CONSTRAINT [PK_HMS_LoginHistory] PRIMARY KEY CLUSTERED 
(
	[LoginHistoryId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1-Login,2-LogOut' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'HMS_LoginHistory', @level2type=N'COLUMN',@level2name=N'Action'
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[HMS_LabTestCategory](
	[LabTestCategoryId] [bigint] IDENTITY(1,1) NOT NULL,
	[LabTestCategoryName] [nvarchar](100) NULL,
	[Description] [nvarchar](500) NULL,
	[CompanyId] [bigint] NULL,
	[IsActive] [bit] NULL,
	[IsDeleted] [bit] NULL,
	[CreatedDate] [datetime] NULL,
	[ModifiedDate] [datetime] NULL,
	[CreatedBy] [bigint] NULL,
	[ModifiedBy] [bigint] NULL,
 CONSTRAINT [PK_HMS_LabTestCategory] PRIMARY KEY CLUSTERED 
(
	[LabTestCategoryId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[HMS_LabTest](
	[LabTestId] [bigint] IDENTITY(1,1) NOT NULL,
	[CompanyId] [bigint] NULL,
	[LabTestName] [nvarchar](100) NULL,
	[LabTestCategoryId] [bigint] NULL,
	[LabTestPrice] [money] NULL,
	[TestUnit] [nvarchar](10) NULL,
	[ReferenceRange] [nvarchar](50) NULL,
	[IsActive] [bit] NULL,
	[IsDeleted] [bit] NULL,
	[CreatedDate] [datetime] NULL,
	[ModifiedDate] [datetime] NULL,
	[CreatedBy] [bigint] NULL,
	[ModifiedBy] [bigint] NULL,
 CONSTRAINT [PK_HMS_LabTest] PRIMARY KEY CLUSTERED 
(
	[LabTestId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[HMS_ExpenseCategory](
	[ExpenseCategoryId] [bigint] IDENTITY(1,1) NOT NULL,
	[ExpenseCategory] [nvarchar](100) NULL,
	[CompanyId] [bigint] NULL,
	[Description] [nvarchar](500) NULL,
	[IsActive] [bit] NULL,
	[IsDeleted] [bit] NULL,
	[CreatedDate] [datetime] NULL,
	[ModifiedDate] [datetime] NULL,
	[CreatedBy] [bigint] NULL,
	[ModifiedBy] [bigint] NULL,
 CONSTRAINT [PK_HMS_ExpenseCategory] PRIMARY KEY CLUSTERED 
(
	[ExpenseCategoryId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[HMS_Expense](
	[ExpenseId] [bigint] IDENTITY(1,1) NOT NULL,
	[CompanyId] [bigint] NULL,
	[ExpenseDate] [datetime] NULL,
	[ExpenseCategoryId] [bigint] NULL,
	[ExpenseAmount] [money] NULL,
	[IsDeleted] [bit] NULL,
	[CreatedDate] [datetime] NULL,
	[ModifiedDate] [datetime] NULL,
	[CreatedBy] [bigint] NULL,
	[ModifiedBy] [bigint] NULL,
 CONSTRAINT [PK_HMS_Expense] PRIMARY KEY CLUSTERED 
(
	[ExpenseId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[HMS_EmailTemplate](
	[EmailTemplateId] [bigint] IDENTITY(1,1) NOT NULL,
	[Code] [varchar](50) NULL,
	[Title] [varchar](100) NULL,
	[Subject] [varchar](100) NULL,
	[FromEmail] [varchar](100) NULL,
	[Message] [nvarchar](max) NULL,
	[Signature] [nvarchar](max) NULL,
	[IsActive] [bit] NULL,
	[IsDeleted] [bit] NULL,
	[CreatedDate] [datetime] NULL,
	[ModifiedDate] [datetime] NULL,
 CONSTRAINT [PK_HMS_EmailTemplate] PRIMARY KEY CLUSTERED 
(
	[EmailTemplateId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[HMS_Company](
	[CompanyId] [bigint] IDENTITY(1,1) NOT NULL,
	[CompanyName] [nvarchar](500) NULL,
	[Address1] [nvarchar](250) NULL,
	[Address2] [nvarchar](250) NULL,
	[City] [nvarchar](50) NULL,
	[State] [nvarchar](50) NULL,
	[ZipCode] [nvarchar](20) NULL,
	[Email] [nvarchar](255) NULL,
	[Phone] [nvarchar](20) NULL,
	[Fax] [nvarchar](20) NULL,
	[IsActive] [bit] NULL,
	[IsDeleted] [bit] NULL,
	[CreatedDate] [datetime] NULL,
	[ModifiedDate] [datetime] NULL,
	[CreatedBy] [bigint] NULL,
 CONSTRAINT [PK_HMS_Company] PRIMARY KEY CLUSTERED 
(
	[CompanyId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[HMS_BloodInventory](
	[BloodInventoryId] [bigint] IDENTITY(1,1) NOT NULL,
	[CompanyId] [bigint] NULL,
	[BloodGroup] [nvarchar](10) NULL,
	[Availability] [nvarchar](10) NULL,
	[ModifiedDate] [datetime] NULL,
	[ModifiedBy] [bigint] NULL,
 CONSTRAINT [PK_HMS_BloodInventory] PRIMARY KEY CLUSTERED 
(
	[BloodInventoryId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[HMS_BloodGroup](
	[BloodGroup] [nvarchar](10) NULL
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[HMS_BedCategory](
	[BedCategoryId] [bigint] IDENTITY(1,1) NOT NULL,
	[BedCategory] [nvarchar](100) NULL,
	[Description] [nvarchar](500) NULL,
	[CompanyId] [bigint] NULL,
	[IsActive] [bit] NULL,
	[IsDeleted] [bit] NULL,
	[CreatedDate] [datetime] NULL,
	[ModifiedDate] [datetime] NULL,
	[CreatedBy] [bigint] NULL,
	[ModifiedBy] [bigint] NULL,
 CONSTRAINT [PK_HMS_BedCategory] PRIMARY KEY CLUSTERED 
(
	[BedCategoryId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[HMS_BedAllotment](
	[BedAllotmentId] [bigint] IDENTITY(1,1) NOT NULL,
	[PatientId] [bigint] NULL,
	[CompanyId] [bigint] NULL,
	[BedCategoryId] [bigint] NULL,
	[BedId] [bigint] NULL,
	[AllotmentDate] [datetime] NULL,
	[DischargeDate] [datetime] NULL,
	[Notes] [nvarchar](500) NULL,
	[CreatedDate] [datetime] NULL,
	[ModifiedDate] [datetime] NULL,
	[CreatedBy] [bigint] NULL,
	[ModifiedBy] [bigint] NULL,
 CONSTRAINT [PK_HMS_BedAllotment] PRIMARY KEY CLUSTERED 
(
	[BedAllotmentId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[HMS_Bed](
	[BedId] [bigint] IDENTITY(1,1) NOT NULL,
	[CompanyId] [bigint] NULL,
	[BedName] [nvarchar](100) NULL,
	[Description] [nvarchar](500) NULL,
	[BedCategoryId] [bigint] NULL,
	[IsAvailable] [bit] NULL,
	[IsActive] [bit] NULL,
	[IsDeleted] [bit] NULL,
	[CreatedDate] [datetime] NULL,
	[ModifiedDate] [datetime] NULL,
	[CreatedBy] [bigint] NULL,
	[ModifiedBy] [bigint] NULL,
 CONSTRAINT [PK_HMS_Bed] PRIMARY KEY CLUSTERED 
(
	[BedId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
ALTER TABLE [dbo].[HMS_Bed] ADD  CONSTRAINT [DF_HMS_Bed_IsAvailable]  DEFAULT ((1)) FOR [IsAvailable]
GO
ALTER TABLE [dbo].[HMS_Bed] ADD  CONSTRAINT [DF_HMS_HMS_Bed_IsDeleted]  DEFAULT ((0)) FOR [IsDeleted]
GO
ALTER TABLE [dbo].[HMS_BedCategory] ADD  CONSTRAINT [DF_HMS_BedCategory_IsDeleted]  DEFAULT ((0)) FOR [IsDeleted]
GO
ALTER TABLE [dbo].[HMS_Company] ADD  CONSTRAINT [DF_HMS_Company_IsDeleted]  DEFAULT ((0)) FOR [IsDeleted]
GO
ALTER TABLE [dbo].[HMS_Expense] ADD  CONSTRAINT [DF_HMS_Expense_IsDeleted]  DEFAULT ((0)) FOR [IsDeleted]
GO
ALTER TABLE [dbo].[HMS_ExpenseCategory] ADD  CONSTRAINT [DF_HMS_ExpenseCategory_IsDeleted]  DEFAULT ((0)) FOR [IsDeleted]
GO
ALTER TABLE [dbo].[HMS_LabTest] ADD  CONSTRAINT [DF_HMS_LabTest_IsDeleted]  DEFAULT ((0)) FOR [IsDeleted]
GO
ALTER TABLE [dbo].[HMS_LabTestCategory] ADD  CONSTRAINT [DF_HMS_LabTestCategory_IsDeleted]  DEFAULT ((0)) FOR [IsDeleted]
GO
ALTER TABLE [dbo].[HMS_Medicine] ADD  CONSTRAINT [DF_HMS_Medicine_IsDeleted]  DEFAULT ((0)) FOR [IsDeleted]
GO
ALTER TABLE [dbo].[HMS_MedicineCategory] ADD  CONSTRAINT [DF_HMS_MedicineCategory_IsDeleted]  DEFAULT ((0)) FOR [IsDeleted]
GO
ALTER TABLE [dbo].[HMS_Payment] ADD  CONSTRAINT [DF_HMS_Payment_IsDeleted]  DEFAULT ((0)) FOR [IsDeleted]
GO
ALTER TABLE [dbo].[HMS_PaymentCategory] ADD  CONSTRAINT [DF_HMS_PaymentCategory_IsDeleted]  DEFAULT ((0)) FOR [IsDeleted]
GO
ALTER TABLE [dbo].[HMS_SiteMenuLTE] ADD  CONSTRAINT [DF_HMS_SiteMenuLTE_Status]  DEFAULT ((1)) FOR [IsActive]
GO
ALTER TABLE [dbo].[HMS_SiteMenuLTE] ADD  CONSTRAINT [DF_HMS_SiteMenuLTE_IsDeleted]  DEFAULT ((0)) FOR [IsDeleted]
GO
ALTER TABLE [dbo].[HMS_Treatment] ADD  CONSTRAINT [DF_HMS_Treatment_IsDeleted]  DEFAULT ((0)) FOR [IsDeleted]
GO
ALTER TABLE [dbo].[HMS_Unit] ADD  CONSTRAINT [DF_HMS_Unit_IsDeleted]  DEFAULT ((0)) FOR [IsDeleted]
GO
