﻿using System.Web;
using System.Web.Optimization;

namespace HMS
{
    public class BundleConfig
    {
        // For more information on bundling, visit http://go.microsoft.com/fwlink/?LinkId=301862
        public static void RegisterBundles(BundleCollection bundles)
        {
            /* Core JS Required for all pages */

            bundles.Add(new ScriptBundle("~/bundles/jquery").Include(
                        "~/Scripts/jquery.js"));

            bundles.Add(new ScriptBundle("~/bundles/jqueryPlugins").Include(
                       "~/plugins/jQueryUI/jquery-ui.js",
                        "~/Scripts/jquery-migrate.js",
                        "~/Scripts/jquery.unobtrusive-ajax.js",
                        "~/Scripts/jquery.validate.js",
                        "~/Scripts/jquery.validate.unobtrusive.js",
                        "~/Scripts/bootstrap.js",
                        "~/plugins/uniform/jquery.uniform.js",
                        "~/Scripts/custom.js",
                        "~/Scripts/GeneralFun.js"
                        ));

            /* jAlert */
            bundles.Add(new ScriptBundle("~/bundles/jalert").Include(
                        "~/plugins/alerts/jquery.alerts.js"));


            /* Date Picker & Date Range Picker */
            bundles.Add(new ScriptBundle("~/bundles/datepickerJS").Include(
                "~/plugins/daterangepicker/moment.js",    
                "~/plugins/daterangepicker/daterangepicker.js",
                    "~/plugins/datepicker/bootstrap-datepicker.js",
                    "~/plugins/bootstrap-datetimepicker/js/bootstrap-datetimepicker.js"
                    ));


            /* Utility Plugins */
            bundles.Add(new ScriptBundle("~/bundles/utilityPluginJS").Include(
                    "~/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.js",
                    "~/plugins/slimScroll/jquery.slimscroll.js",
                    "~/plugins/fastclick/fastclick.js"
                    ));

            /* CK Editor Plugin */
            bundles.Add(new ScriptBundle("~/bundles/editorPluginJS").Include(
                    "~/plugins/ckeditor/ckeditor.js" ));


            /* App JS */
            bundles.Add(new ScriptBundle("~/bundles/appJS").Include("~/Scripts/app.js"));

            /* Early Load */
            bundles.Add(new ScriptBundle("~/bundles/earlyLoad").Include(
                        "~/Scripts/earlyLoad.js"
                        ));

            // Use the development version of Modernizr to develop with and learn from. Then, when you're
            // ready for production, use the build tool at http://modernizr.com to pick only the tests you need.
            bundles.Add(new ScriptBundle("~/bundles/modernizr").Include(
                        "~/Scripts/modernizr-*"));
        

            /* Core CSS */
            bundles.Add(new StyleBundle("~/Content/mainCSS").Include(
                        "~/Content/bootstrap/bootstrap.css",
                        "~/Content/font-awesome/font-awesome.css",
                        "~/plugins/datatables/dataTables.bootstrap.css",
                        "~/Content/css/AdminLTE.css",
                        "~/plugins/alerts/jquery.alerts.css",
                        "~/Content/css/style_custom.css"
                        ));


            //bundles.Add(new StyleBundle("~/plugins/iCheck/flat/css").Include(
            //"~/plugins/iCheck/flat/blue.css"));

            /*Theme Style */
            bundles.Add(new StyleBundle("~/Content/themeCSS").Include(
                        //"~/Content/css/AdminLTE.css",
                        "~/Content/css/skins/_all-skins.css"
                        ));


            /* Date Picker CSS */
            bundles.Add(new StyleBundle("~/Content/datepickerCSS").Include(
                        "~/plugins/datepicker/datepicker3.css",
                        "~/plugins/daterangepicker/daterangepicker.css",
                        "~/plugins/bootstrap-datetimepicker/css/bootstrap-datetimepicker.css"
                        
                        ));

            /* jAlert CSS */
            bundles.Add(new StyleBundle("~/plugins/alerts/jAlertCSS").Include(
                        "~/plugins/alerts/jquery.alerts.css" ));

            /* Utility CSS */
            bundles.Add(new StyleBundle("~/Content/utilityCSS").Include(
                        "~/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.css",
                        "~/plugins/daterangepicker/daterangepicker.css"
                        ));


            /* Uniform CSS */
            bundles.Add(new StyleBundle("~/plugins/uniform/css/uniformcss").Include("~/plugins/uniform/css/uniform.default.css"));


       
        }
    }
}
