﻿using System.Collections.Generic;
using HMS.Class.DAL;
using HMS.Class.Helper;
using HMS.Models;

namespace HMS.Class.BLL
{
    
    public class LabTestBLL
    {
        #region LabTest

        public static List<LabTestModel> GetAll(string searchField, string searchValue, string sortField, string sortOrder, int pageNo, int pageSize)
        {
            using (LabTestDAL labTestDAL = new LabTestDAL())
            {
                return labTestDAL.GetAll( searchField, searchValue, sortField, sortOrder, pageNo, pageSize);
            }
        }

        public static List<LabTestModel> GetAllActive()
        {
            using (LabTestDAL labTestDAL = new LabTestDAL())
            {
                return labTestDAL.GetAll("IsActive", "1", "LabTestName", "ASC", 0, 0);
            }
        }

        /// <summary>
        /// Gets the by id.
        /// </summary>
        /// <param name="labTestId">The user id.</param>
        /// <returns>Returns user by id.</returns>
        public static LabTestModel GetById(long labTestId)
        {
            using (LabTestDAL labTestDAL = new LabTestDAL())
            {
                return labTestDAL.GetById(labTestId);
            }
        }

     

        /// <summary>
        /// Saves the specified user.
        /// </summary>
        /// <param name="company">The user.</param>
        /// <returns>Returns user id if success else duplicate column name.</returns>
        public static LabTestModel Save(LabTestModel company)
        {
            using (LabTestDAL labTestDAL = new LabTestDAL())
            {
                return labTestDAL.Save(company);
            }
        }

        /// <summary>
        /// Updates the multiple records.
        /// </summary>
        /// <param name="operationType">Type of the operation.</param>
        /// <param name="multiIds">The multi ids.</param>
        /// <returns>Returns 1 if success else 0.</returns>
        public static int UpdateMultipleRecords(MultiOperationType operationType, string multiIds)
        {
            using (LabTestDAL labTestDAL = new LabTestDAL())
            {
                return labTestDAL.UpdateMultipleRecords(operationType, multiIds);
            }
        }

    

        #endregion
    }
}