﻿using System.Collections.Generic;
using HMS.Class.DAL;
using HMS.Class.Helper;
using HMS.Models;

namespace HMS.Class.BLL
{

    public class LabTestCategoryBLL
    {
        #region LabTest

        public static List<LabTestCategoryModel> GetAll(string searchField, string searchValue, string sortField, string sortOrder, int pageNo, int pageSize)
        {
            using (LabTestCategoryDAL labTestCategoryDAL = new LabTestCategoryDAL())
            {
                return labTestCategoryDAL.GetAll( searchField, searchValue, sortField, sortOrder, pageNo, pageSize);
            }
        }

        public static List<LabTestCategoryModel> GetAllActive()
        {
            using (LabTestCategoryDAL labTestCategoryDAL = new LabTestCategoryDAL())
            {
                return labTestCategoryDAL.GetAll("IsActive", "1", "LabTestCategoryName", "ASC", 0, 0);
            }
        }

        /// <summary>
        /// Gets the by id.
        /// </summary>
        /// <param name="labTestId">The user id.</param>
        /// <returns>Returns user by id.</returns>
        public static LabTestCategoryModel GetById(long labTestId)
        {
            using (LabTestCategoryDAL labTestCategoryDAL = new LabTestCategoryDAL())
            {
                return labTestCategoryDAL.GetById(labTestId);
            }
        }

     

        /// <summary>
        /// Saves the specified user.
        /// </summary>
        /// <param name="company">The user.</param>
        /// <returns>Returns user id if success else duplicate column name.</returns>
        public static LabTestCategoryModel Save(LabTestCategoryModel company)
        {
            using (LabTestCategoryDAL labTestCategoryDAL = new LabTestCategoryDAL())
            {
                return labTestCategoryDAL.Save(company);
            }
        }

        /// <summary>
        /// Updates the multiple records.
        /// </summary>
        /// <param name="operationType">Type of the operation.</param>
        /// <param name="multiIds">The multi ids.</param>
        /// <returns>Returns 1 if success else 0.</returns>
        public static int UpdateMultipleRecords(MultiOperationType operationType, string multiIds)
        {
            using (LabTestCategoryDAL labTestCategoryDAL = new LabTestCategoryDAL())
            {
                return labTestCategoryDAL.UpdateMultipleRecords(operationType, multiIds);
            }
        }

    

        #endregion
    }
}