﻿using System.Collections.Generic;
using HMS.Class.DAL;
using HMS.Class.Helper;
using HMS.Models;
using HMS.ViewModel;

namespace HMS.Class.BLL
{
    /// <summary>
    /// User BLL class.
    /// </summary>
    public class PatientBLL
    {
        #region Public Methods

        /// <summary>
        /// Gets all.
        /// </summary>
        /// <param name="roleType">Type of the role.</param>
        /// <param name="searchField">The search field.</param>
        /// <param name="searchValue">The search value.</param>
        /// <param name="sortField">The sort field.</param>
        /// <param name="sortOrder">The sort order.</param>
        /// <param name="pageNo">The page no.</param>
        /// <param name="pageSize">Size of the page.</param>
        /// <returns>
        /// Returns all users.
        /// </returns>
        public static List<PatientModel> GetAll(string searchField, string searchValue, string sortField, string sortOrder, int pageNo, int pageSize)
        {
            using (PatientDAL patientDAL = new PatientDAL())
            {
                return patientDAL.GetAll(searchField, searchValue, sortField, sortOrder, pageNo, pageSize);
            }
        }

        public static List<PatientModel> GetAllActive()
        {
            using (PatientDAL patientDAL = new PatientDAL())
            {
                return patientDAL.GetAll("IsActive", "1", "FirstName", "ASC", 0, 0);
            }
        }


        /// <summary>
        /// Gets the by id.
        /// </summary>
        /// <param name="userId">The user id.</param>
        /// <returns>Returns user by id.</returns>
        public static PatientModel GetById(long userId)
        {
            using (PatientDAL patientDAL = new PatientDAL())
            {
                return patientDAL.GetById(userId);
            }
        }

        /// <summary>
        /// Saves the specified user.
        /// </summary>
        /// <param name="user">The user.</param>
        /// <returns>Returns user id if success else duplicate column name.</returns>
        public static PatientModel Save(PatientModel user)
        {
            using (PatientDAL patientDAL = new PatientDAL())
            {
                return patientDAL.Save(user);
            }
        }

        /// <summary>
        /// Updates the multiple records.
        /// </summary>
        /// <param name="operationType">Type of the operation.</param>
        /// <param name="multiIds">The multi ids.</param>
        /// <returns>Returns 1 if success else 0.</returns>
        public static int UpdateMultipleRecords(MultiOperationType operationType, string multiIds)
        {
            using (PatientDAL patientDAL = new PatientDAL())
            {
                return patientDAL.UpdateMultipleRecords(operationType, multiIds);
            }
        }


        #region Patient Checkup

        public static List<PatientCheckupModel> GetAllCheckupDetail(long patientId)
        {
            var checkupDetail = new List<PatientCheckupModel>();
            var prescription = new List<PrescriptionModel>();
            using (PatientDAL patientDAL = new PatientDAL())
            {
                checkupDetail = patientDAL.GetAllCheckupDetail(patientId);
                prescription = GetAllPrescriptionDetail(patientId);

                foreach (var c in checkupDetail)
                {
                    c.Prescription = prescription.Find(p => p.PatientCheckupId == c.PatientCheckupId);
                }
            }

            return checkupDetail;
        }

        public static PatientCheckupModel GetCheckupDetail(long patientCheckupId)
        {
            var checkupDetail = new PatientCheckupModel();
            var prescription = new PrescriptionModel();

            using (PatientDAL patientDAL = new PatientDAL())
            {
                checkupDetail = patientDAL.GetCheckupDetail(patientCheckupId);
                prescription = GetPrescriptionDetailByCheckupId(patientCheckupId);

                checkupDetail.Prescription = prescription;
            }

            return checkupDetail;
        }

        public static long SaveCheckupDetail(PatientCheckupViewModel patientCheckupVM)
        {
            using (PatientDAL patientDAL = new PatientDAL())
            {
                long patientCheckupId =  patientDAL.SaveCheckupDetail(patientCheckupVM);
                PrescriptionModel prescription = patientCheckupVM.PatientCheckup.Prescription;
                prescription.PatientId = patientCheckupVM.PatientCheckup.PatientId;
                prescription.PatientCheckupId = patientCheckupId;
                SavePrescription(prescription);

                return patientCheckupId;
            }
        }

        public static int DeleteCheckupDetail(long patientCheckupId)
        {
            using (PatientDAL patientDAL = new PatientDAL())
            {
                return patientDAL.DeleteCheckupDetail(patientCheckupId);
            }
        }

        #endregion

        #region Patient Prescription
        public static List<PrescriptionModel> GetAllPrescriptionDetail(long patientId)
        {
            using (PatientDAL patientDAL = new PatientDAL())
            {
                return patientDAL.GetAllPrescriptionDetail(patientId);
            }
        }

        public static PrescriptionModel GetPrescriptionDetailByCheckupId(long patientCheckupId)
        {
            using (PatientDAL patientDAL = new PatientDAL())
            {
                return patientDAL.GetPrescriptionDetailByCheckupId(patientCheckupId);
            }
        }

        public static long SavePrescription(PrescriptionModel prescription)
        {
            using (PatientDAL patientDAL = new PatientDAL())
            {
                long prescriptionId  =  patientDAL.SavePrescription(prescription);
                SavePrescriptionDetail(prescriptionId, prescription.PatientId, prescription.MedicineList);
                return prescriptionId;
            }

            
        }

        public static void SavePrescriptionDetail(long prescriptionId, long patientId, List<PrescriptionDetailModel> medicineList)
        {
            string prescriptionData = string.Empty;

            foreach (var medicine in medicineList)
            {
                prescriptionData = string.Concat(prescriptionData, medicine.MedicineId, ",", medicine.NoOfDays, ",", medicine.WhenToTake, ",", medicine.IsBeforeMeal, "#");
            }

            prescriptionData = prescriptionData.TrimEnd('#');

            using (PatientDAL patientDAL = new PatientDAL())
            {
                patientDAL.SavePrescriptionDetail(prescriptionId, patientId, prescriptionData);
            }
        }

        #endregion


        #endregion
    }
}