﻿using System.Collections.Generic;
using HMS.Class.DAL;
using HMS.Class.Helper;
using HMS.Models;
using HMS.ViewModel;

namespace HMS.Class.BLL
{
    
    public class PaymentBLL
    {
        #region Payment

        public static List<PaymentModel> GetAll(string searchField, string searchValue, string sortField, string sortOrder, int pageNo, int pageSize)
        {
            using (PaymentDAL paymentDAL = new PaymentDAL())
            {
                return paymentDAL.GetAll( searchField, searchValue, sortField, sortOrder, pageNo, pageSize);
            }
        }

        public static List<PaymentModel> GetAllActive()
        {
            using (PaymentDAL paymentDAL = new PaymentDAL())
            {
                return paymentDAL.GetAll("IsActive", "1", "PaymentDate", "ASC", 0, 0);
            }
        }

        /// <summary>
        /// Gets the by id.
        /// </summary>
        /// <param name="paymentId">The user id.</param>
        /// <returns>Returns user by id.</returns>
        public static PaymentModel GetById(long paymentId)
        {
            using (PaymentDAL paymentDAL = new PaymentDAL())
            {
                return paymentDAL.GetById(paymentId);
            }
        }

     

        /// <summary>
        /// Saves the specified user.
        /// </summary>
        /// <param name="company">The user.</param>
        /// <returns>Returns user id if success else duplicate column name.</returns>
        public static long Save(PaymentViewModel paymentVM)
        {
            using (PaymentDAL paymentDAL = new PaymentDAL())
            {
                if (paymentVM.PaymentDetails != null)
                {
                    List<PaymentDetailModel> paymentDetailList = paymentVM.PaymentDetails;
                    var subTotal = 0.0M;
                    foreach (var cat in paymentDetailList)
                    {
                        subTotal += cat.PaymentAmount;
                    }

                    paymentVM.Payment.SubTotal = subTotal;
                    paymentVM.Payment.GrandTotal = subTotal + paymentVM.Payment.Tax - paymentVM.Payment.Discount;

                }

                long paymentId =  paymentDAL.Save(paymentVM.Payment);

                SavePaymentDetail(paymentId, paymentVM.PaymentDetails);


                return paymentId;
            }
        }

        /// <summary>
        /// Updates the multiple records.
        /// </summary>
        /// <param name="operationType">Type of the operation.</param>
        /// <param name="multiIds">The multi ids.</param>
        /// <returns>Returns 1 if success else 0.</returns>
        public static int UpdateMultipleRecords(MultiOperationType operationType, string multiIds)
        {
            using (PaymentDAL paymentDAL = new PaymentDAL())
            {
                return paymentDAL.UpdateMultipleRecords(operationType, multiIds);
            }
        }

        public static int UpdatePaymentStatus(PaymentStatusType paymentStatusType, string multiIds)
        {
            using (PaymentDAL paymentDAL = new PaymentDAL())
            {
                return paymentDAL.UpdatePaymentStatus(paymentStatusType, multiIds);
            }
        }

    

        #endregion

        #region Payment Detail

        public static List<PaymentDetailModel> GetPaymentDetailByPayment(long paymentId)
        {
            using (PaymentDAL paymentDAL = new PaymentDAL())
            {
                return paymentDAL.GetPaymentDetailByPayment(paymentId);
            }
        }

        public static void SavePaymentDetail(long paymentId, List<PaymentDetailModel> paymentDetailList)
        {
            string chargesData = string.Empty;

            foreach (var cat in paymentDetailList)
            {
                if (cat.PaymentAmount > 0)
                {
                    chargesData = string.Concat(chargesData, cat.PaymentCategoryId, ",", cat.PaymentAmount, "#");
                }
            }

            chargesData = chargesData.TrimEnd('#');

            using (PaymentDAL paymentDAL = new PaymentDAL())
            {
                paymentDAL.SavePaymentDetail(paymentId, chargesData);
            }
        }

        #endregion
    }
}