﻿using System;
using System.Collections.Generic;
using System.Data;
using HMS.Class.Helper;
using HMS.Models;

namespace HMS.Class.DAL
{

    public class BedAllotmentDAL : IDisposable
    {
        #region Variable Declaration

        private DBHelper databaseHelper;

        #endregion

        #region BedAllotment

        #region Public Methods
        public List<BedAllotmentModel> GetAll( string searchField, string searchValue, string sortField, string sortOrder, int pageNo, int pageSize)
        {
            try
            {
                this.databaseHelper = new DBHelper();

                this.databaseHelper.SetParameterToSQLCommand("@SearchField", searchField);
                this.databaseHelper.SetParameterToSQLCommand("@SearchValue", searchValue);
                this.databaseHelper.SetParameterToSQLCommand("@SortField", sortField);
                this.databaseHelper.SetParameterToSQLCommand("@SortOrder", sortOrder);
                this.databaseHelper.SetParameterToSQLCommand("@PageNo", pageNo);
                this.databaseHelper.SetParameterToSQLCommand("@PageSize", pageSize);

                long companyId = SqlHelper.ParseNativeLong(CommonLogic.GetSessionValue(StringConstants.CompanyId));
                this.databaseHelper.SetParameterToSQLCommand("@CompanyId ", companyId);

                IDataReader dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spS_BedAllotment");

                return this.GetBedAllotmentData(dataReader);
            }
            catch
            {
                throw;
            }
            finally
            {
                this.databaseHelper.CloseConnection();
            }
        }

        public BedAllotmentModel GetById(long bedAllotmentId)
        {
            try
            {
                this.databaseHelper = new DBHelper();

                this.databaseHelper.SetParameterToSQLCommand("@BedAllotmentId", bedAllotmentId);
                IDataReader dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spS_BedAllotmentById");

                List<BedAllotmentModel> list = this.GetBedAllotmentData(dataReader);

                if (list != null && list.Count > 0)
                {
                    return list[0];
                }
                else
                {
                    return null;
                }
            }
            catch
            {
                throw;
            }
            finally
            {
                this.databaseHelper.CloseConnection();
            }
        }
      
        public BedAllotmentModel Save(BedAllotmentModel bedAllotment)
        {
            this.databaseHelper = new DBHelper();

            
            this.databaseHelper.SetParameterToSQLCommand("@PatientId", bedAllotment.PatientId);
            this.databaseHelper.SetParameterToSQLCommand("@BedCategoryId", bedAllotment.BedCategoryId);
            this.databaseHelper.SetParameterToSQLCommand("@BedId", bedAllotment.BedId);
            this.databaseHelper.SetParameterToSQLCommand("@AllotmentDate", bedAllotment.AllotmentDate);
            this.databaseHelper.SetParameterToSQLCommand("@DischargeDate", bedAllotment.DischargeDate);
            this.databaseHelper.SetParameterToSQLCommand("@Notes", bedAllotment.Notes);
            this.databaseHelper.SetParameterToSQLCommand("@CreatedBy", bedAllotment.CreatedBy);
            this.databaseHelper.SetParameterToSQLCommand("@CompanyId", bedAllotment.CompanyId);

            IDataReader dataReader;
            BedAllotmentModel tempUser = new BedAllotmentModel();

            if (bedAllotment.BedAllotmentId > 0)
            {
                this.databaseHelper.SetParameterToSQLCommand("@BedAllotmentId", bedAllotment.BedAllotmentId);
                dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spU_BedAllotment");
            }
            else
            {
                dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spI_BedAllotment");
            }

            if (dataReader != null)
            {
                using (dataReader)
                {
                    while (dataReader.Read())
                    {
                        tempUser.BedAllotmentId = SqlHelper.GetDBLongValue(dataReader["RETURNVAL"]);
                        tempUser.DuplicateColumn = SqlHelper.GetDBStringValue(dataReader["DuplicateColumn"]);
                    }

                    return tempUser;
                }
            }
            else
            {
                return null;
            }
        }

        public int UpdateMultipleRecords(MultiOperationType operationType, string multiIds)
        {
            this.databaseHelper = new DBHelper();

            this.databaseHelper.SetParameterToSQLCommand("@MultiIds", multiIds);
            this.databaseHelper.SetParameterToSQLCommand("@OperationType", (int)operationType);

            return SqlHelper.ParseNativeInt(this.databaseHelper.GetExecuteScalarByStoredProcedure("HMS_spM_BedAllotment").ToString());
        }

        #endregion

        #region Private Methods

        private List<BedAllotmentModel> GetBedAllotmentData(IDataReader dataReader)
        {
            if (dataReader != null)
            {
                using (dataReader)
                {
                    BedAllotmentModel bedAllotment;
                    List<BedAllotmentModel> bedAllotmentList = new List<BedAllotmentModel>();

                    while (dataReader.Read())
                    {
                        bedAllotment = new BedAllotmentModel();

                        bedAllotment.BedAllotmentId = SqlHelper.GetDBLongValue(dataReader["BedAllotmentId"]);
                        bedAllotment.PatientId = SqlHelper.GetDBLongValue(dataReader["PatientId"]);
                        bedAllotment.PatientName = SqlHelper.GetDBStringValue(dataReader["PatientName"]);
                        bedAllotment.BedId = SqlHelper.GetDBLongValue(dataReader["BedId"]);
                        bedAllotment.BedName = SqlHelper.GetDBStringValue(dataReader["BedName"]);
                        bedAllotment.BedCategoryId = SqlHelper.GetDBLongValue(dataReader["BedCategoryId"]);
                        bedAllotment.AllotmentDate = SqlHelper.GetDBDateTimeValue(dataReader["AllotmentDate"]);
                        bedAllotment.DischargeDate = SqlHelper.GetDBDateTimeValue(dataReader["DischargeDate"]);

                        if (bedAllotment.DischargeDate == default(DateTime))
                        {
                            bedAllotment.DischargeDate = null;
                        }

                        bedAllotment.Notes = SqlHelper.GetDBStringValue(dataReader["Notes"]);
                        
                        bedAllotmentList.Add(bedAllotment);
                    }

                    if (bedAllotmentList.Count > 0)
                    {
                        dataReader.NextResult();

                        while (dataReader.Read())
                        {
                            bedAllotmentList[0].TotalRecordCount = SqlHelper.GetDBIntValue(dataReader["TotalRecordCount"]);
                        }
                    }

                    return bedAllotmentList;
                }
            }
            else
            {
                return null;
            }
        }
        #endregion

        #endregion

        #region Dispose Methods

        /// <summary>
        /// Performs application-defined tasks associated with freeing, releasing, or resetting unmanaged resources.
        /// </summary>
        public void Dispose()
        {
            this.Dispose(true);
        }

        /// <summary>
        /// Releases unmanaged and - optionally - managed resources.
        /// </summary>
        /// <param name="disposing"><c>true</c> to release both managed and unmanaged resources; <c>false</c> to release only unmanaged resources.</param>
        protected virtual void Dispose(bool disposing)
        {
            if (disposing)
            {
                this.databaseHelper.Dispose();
            }
        }

        #endregion
    }
}