﻿using System;
using System.Collections.Generic;
using System.Data;
using HMS.Class.Helper;
using HMS.Models;

namespace HMS.Class.DAL
{

    public class BedCategoryDAL : IDisposable
    {
        #region Variable Declaration

        private DBHelper databaseHelper;

        #endregion

        #region BedCategory

        #region Public Methods
        public List<BedCategoryModel> GetAll( string searchField, string searchValue, string sortField, string sortOrder, int pageNo, int pageSize)
        {
            try
            {
                this.databaseHelper = new DBHelper();

                this.databaseHelper.SetParameterToSQLCommand("@SearchField", searchField);
                this.databaseHelper.SetParameterToSQLCommand("@SearchValue", searchValue);
                this.databaseHelper.SetParameterToSQLCommand("@SortField", sortField);
                this.databaseHelper.SetParameterToSQLCommand("@SortOrder", sortOrder);
                this.databaseHelper.SetParameterToSQLCommand("@PageNo", pageNo);
                this.databaseHelper.SetParameterToSQLCommand("@PageSize", pageSize);

                long companyId = SqlHelper.ParseNativeLong(CommonLogic.GetSessionValue(StringConstants.CompanyId));
                this.databaseHelper.SetParameterToSQLCommand("@CompanyId ", companyId);

                IDataReader dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spS_BedCategory");

                return this.GetBedCategoryData(dataReader);
            }
            catch
            {
                throw;
            }
            finally
            {
                this.databaseHelper.CloseConnection();
            }
        }

        public BedCategoryModel GetById(long bedCategoryId)
        {
            try
            {
                this.databaseHelper = new DBHelper();

                this.databaseHelper.SetParameterToSQLCommand("@BedCategoryId", bedCategoryId);
                IDataReader dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spS_BedCategoryById");

                List<BedCategoryModel> list = this.GetBedCategoryData(dataReader);

                if (list != null && list.Count > 0)
                {
                    return list[0];
                }
                else
                {
                    return null;
                }
            }
            catch
            {
                throw;
            }
            finally
            {
                this.databaseHelper.CloseConnection();
            }
        }
      
        public BedCategoryModel Save(BedCategoryModel bedCategory)
        {
            this.databaseHelper = new DBHelper();

            this.databaseHelper.SetParameterToSQLCommand("@BedCategory", bedCategory.BedCategory);
            this.databaseHelper.SetParameterToSQLCommand("@Description", bedCategory.Description);
            this.databaseHelper.SetParameterToSQLCommand("@IsActive", bedCategory.IsActive);
            this.databaseHelper.SetParameterToSQLCommand("@CreatedBy", bedCategory.CreatedBy);
            this.databaseHelper.SetParameterToSQLCommand("@CompanyId", bedCategory.CompanyId);

            IDataReader dataReader;
            BedCategoryModel tempUser = new BedCategoryModel();

            if (bedCategory.BedCategoryId > 0)
            {
                this.databaseHelper.SetParameterToSQLCommand("@BedCategoryId", bedCategory.BedCategoryId);
                dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spU_BedCategory");
            }
            else
            {
                dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spI_BedCategory");
            }

            if (dataReader != null)
            {
                using (dataReader)
                {
                    while (dataReader.Read())
                    {
                        tempUser.BedCategoryId = SqlHelper.GetDBLongValue(dataReader["RETURNVAL"]);
                        tempUser.DuplicateColumn = SqlHelper.GetDBStringValue(dataReader["DuplicateColumn"]);
                    }

                    return tempUser;
                }
            }
            else
            {
                return null;
            }
        }

        public int UpdateMultipleRecords(MultiOperationType operationType, string multiIds)
        {
            this.databaseHelper = new DBHelper();

            this.databaseHelper.SetParameterToSQLCommand("@MultiIds", multiIds);
            this.databaseHelper.SetParameterToSQLCommand("@OperationType", (int)operationType);

            return SqlHelper.ParseNativeInt(this.databaseHelper.GetExecuteScalarByStoredProcedure("HMS_spM_BedCategory").ToString());
        }

        #endregion

        #region Private Methods

        private List<BedCategoryModel> GetBedCategoryData(IDataReader dataReader)
        {
            if (dataReader != null)
            {
                using (dataReader)
                {
                    BedCategoryModel bedCategory;
                    List<BedCategoryModel> bedCategoryList = new List<BedCategoryModel>();

                    while (dataReader.Read())
                    {
                        bedCategory = new BedCategoryModel();

                        bedCategory.BedCategoryId = SqlHelper.GetDBLongValue(dataReader["BedCategoryId"]);
                        bedCategory.BedCategory = SqlHelper.GetDBStringValue(dataReader["BedCategory"]);
                        bedCategory.Description = SqlHelper.GetDBStringValue(dataReader["Description"]);
                        bedCategory.IsActive = SqlHelper.GetDBBoolValue(dataReader["IsActive"]);

                        bedCategoryList.Add(bedCategory);
                    }

                    if (bedCategoryList.Count > 0)
                    {
                        dataReader.NextResult();

                        while (dataReader.Read())
                        {
                            bedCategoryList[0].TotalRecordCount = SqlHelper.GetDBIntValue(dataReader["TotalRecordCount"]);
                        }
                    }

                    return bedCategoryList;
                }
            }
            else
            {
                return null;
            }
        }
        #endregion

        #endregion

        #region Dispose Methods

        /// <summary>
        /// Performs application-defined tasks associated with freeing, releasing, or resetting unmanaged resources.
        /// </summary>
        public void Dispose()
        {
            this.Dispose(true);
        }

        /// <summary>
        /// Releases unmanaged and - optionally - managed resources.
        /// </summary>
        /// <param name="disposing"><c>true</c> to release both managed and unmanaged resources; <c>false</c> to release only unmanaged resources.</param>
        protected virtual void Dispose(bool disposing)
        {
            if (disposing)
            {
                this.databaseHelper.Dispose();
            }
        }

        #endregion
    }
}