﻿using System;
using System.Collections.Generic;
using System.Data;
using HMS.Class.Helper;
using HMS.Models;

namespace HMS.Class.DAL
{

    public class BedDAL : IDisposable
    {
        #region Variable Declaration

        private DBHelper databaseHelper;

        #endregion

        #region Bed

        #region Public Methods
        public List<BedModel> GetAll( string searchField, string searchValue, string sortField, string sortOrder, int pageNo, int pageSize)
        {
            try
            {
                this.databaseHelper = new DBHelper();

                this.databaseHelper.SetParameterToSQLCommand("@SearchField", searchField);
                this.databaseHelper.SetParameterToSQLCommand("@SearchValue", searchValue);
                this.databaseHelper.SetParameterToSQLCommand("@SortField", sortField);
                this.databaseHelper.SetParameterToSQLCommand("@SortOrder", sortOrder);
                this.databaseHelper.SetParameterToSQLCommand("@PageNo", pageNo);
                this.databaseHelper.SetParameterToSQLCommand("@PageSize", pageSize);

                long companyId = SqlHelper.ParseNativeLong(CommonLogic.GetSessionValue(StringConstants.CompanyId));
                this.databaseHelper.SetParameterToSQLCommand("@CompanyId ", companyId);

                IDataReader dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spS_Bed");

                return this.GetBedData(dataReader);
            }
            catch
            {
                throw;
            }
            finally
            {
                this.databaseHelper.CloseConnection();
            }
        }

        public BedModel GetById(long bedId)
        {
            try
            {
                this.databaseHelper = new DBHelper();

                this.databaseHelper.SetParameterToSQLCommand("@BedId", bedId);
                IDataReader dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spS_BedById");

                List<BedModel> list = this.GetBedData(dataReader);

                if (list != null && list.Count > 0)
                {
                    return list[0];
                }
                else
                {
                    return null;
                }
            }
            catch
            {
                throw;
            }
            finally
            {
                this.databaseHelper.CloseConnection();
            }
        }
      
        public BedModel Save(BedModel bed)
        {
            this.databaseHelper = new DBHelper();

            this.databaseHelper.SetParameterToSQLCommand("@BedName", bed.BedName);
            this.databaseHelper.SetParameterToSQLCommand("@Description", bed.Description);
            this.databaseHelper.SetParameterToSQLCommand("@BedCategoryId", bed.BedCategoryId);
            this.databaseHelper.SetParameterToSQLCommand("@IsActive", bed.IsActive);
            this.databaseHelper.SetParameterToSQLCommand("@CreatedBy", bed.CreatedBy);
            this.databaseHelper.SetParameterToSQLCommand("@CompanyId", bed.CompanyId);

            IDataReader dataReader;
            BedModel tempUser = new BedModel();

            if (bed.BedId > 0)
            {
                this.databaseHelper.SetParameterToSQLCommand("@BedId", bed.BedId);
                dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spU_Bed");
            }
            else
            {
                dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spI_Bed");
            }

            if (dataReader != null)
            {
                using (dataReader)
                {
                    while (dataReader.Read())
                    {
                        tempUser.BedId = SqlHelper.GetDBLongValue(dataReader["RETURNVAL"]);
                        tempUser.DuplicateColumn = SqlHelper.GetDBStringValue(dataReader["DuplicateColumn"]);
                    }

                    return tempUser;
                }
            }
            else
            {
                return null;
            }
        }

        public int UpdateMultipleRecords(MultiOperationType operationType, string multiIds)
        {
            this.databaseHelper = new DBHelper();

            this.databaseHelper.SetParameterToSQLCommand("@MultiIds", multiIds);
            this.databaseHelper.SetParameterToSQLCommand("@OperationType", (int)operationType);

            return SqlHelper.ParseNativeInt(this.databaseHelper.GetExecuteScalarByStoredProcedure("HMS_spM_Bed").ToString());
        }

        public List<BedModel> GetAvailableBeds(long bedCategoryId, string bedId)
        {
            try
            {
                this.databaseHelper = new DBHelper();

                this.databaseHelper.SetParameterToSQLCommand("@BedCategoryId", bedCategoryId);
                this.databaseHelper.SetParameterToSQLCommand("@BedId", SqlHelper.ParseNativeLong(bedId));
                
                long companyId = SqlHelper.ParseNativeLong(CommonLogic.GetSessionValue(StringConstants.CompanyId));
                this.databaseHelper.SetParameterToSQLCommand("@CompanyId ", companyId);

                IDataReader dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spS_AvailableBeds");

                return this.GetBedData(dataReader);
            }
            catch
            {
                throw;
            }
            finally
            {
                this.databaseHelper.CloseConnection();
            }
        }

        #endregion

        #region Private Methods

        private List<BedModel> GetBedData(IDataReader dataReader)
        {
            if (dataReader != null)
            {
                using (dataReader)
                {
                    BedModel bed;
                    List<BedModel> bedList = new List<BedModel>();

                    while (dataReader.Read())
                    {
                        bed = new BedModel();

                        bed.BedId = SqlHelper.GetDBLongValue(dataReader["BedId"]);
                        bed.BedName = SqlHelper.GetDBStringValue(dataReader["BedName"]);
                        bed.Description = SqlHelper.GetDBStringValue(dataReader["Description"]);
                        bed.BedCategoryId = SqlHelper.GetDBLongValue(dataReader["BedCategoryId"]);
                        bed.BedCategory = SqlHelper.GetDBStringValue(dataReader["BedCategory"]);
                        bed.IsActive = SqlHelper.GetDBBoolValue(dataReader["IsActive"]);
                        bed.IsAvailable = SqlHelper.GetDBBoolValue(dataReader["IsAvailable"]);

                        bedList.Add(bed);
                    }

                    if (bedList.Count > 0)
                    {
                        dataReader.NextResult();

                        while (dataReader.Read())
                        {
                            bedList[0].TotalRecordCount = SqlHelper.GetDBIntValue(dataReader["TotalRecordCount"]);
                        }
                    }

                    return bedList;
                }
            }
            else
            {
                return null;
            }
        }
        #endregion

        #endregion

        #region Dispose Methods

        /// <summary>
        /// Performs application-defined tasks associated with freeing, releasing, or resetting unmanaged resources.
        /// </summary>
        public void Dispose()
        {
            this.Dispose(true);
        }

        /// <summary>
        /// Releases unmanaged and - optionally - managed resources.
        /// </summary>
        /// <param name="disposing"><c>true</c> to release both managed and unmanaged resources; <c>false</c> to release only unmanaged resources.</param>
        protected virtual void Dispose(bool disposing)
        {
            if (disposing)
            {
                this.databaseHelper.Dispose();
            }
        }

        #endregion
    }
}