﻿using System;
using System.Collections.Generic;
using System.Data;
using HMS.Class.Helper;
using HMS.Models;

namespace HMS.Class.DAL
{

    public class BloodInventoryDAL : IDisposable
    {
        #region Variable Declaration

        private DBHelper databaseHelper;

        #endregion

        #region Public Methods

        public List<BloodInventoryModel> GetBloodInventory()
        {
            try
            {
                this.databaseHelper = new DBHelper();

                long companyId = SqlHelper.ParseNativeLong(CommonLogic.GetSessionValue(StringConstants.CompanyId));
                this.databaseHelper.SetParameterToSQLCommand("@CompanyId ", companyId);

                IDataReader dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spS_BloodInventory");


                if (dataReader != null)
                {
                    using (dataReader)
                    {
                        BloodInventoryModel inventory;
                        List<BloodInventoryModel> inventoryList = new List<BloodInventoryModel>();

                        while (dataReader.Read())
                        {
                            inventory = new BloodInventoryModel();

                            inventory.BloodGroup= SqlHelper.GetDBStringValue(dataReader["BloodGroup"]);
                            inventory.Availability = SqlHelper.GetDBIntValue(dataReader["Availability"]);

                            inventoryList.Add(inventory);
                        }

                        return inventoryList;
                    }
                }
                else
                {
                    return null;
                }
            }
            catch
            {
                throw;
            }
            finally
            {
                this.databaseHelper.CloseConnection();
            }
        }

        public void SaveBloodInventory(string inventoryData)
        {
            this.databaseHelper = new DBHelper();

            long companyId = SqlHelper.ParseNativeLong(CommonLogic.GetSessionValue(StringConstants.CompanyId));
            long userId = SqlHelper.ParseNativeLong(CommonLogic.GetSessionValue(StringConstants.UserId));

            this.databaseHelper.SetParameterToSQLCommand("@CompanyId ", companyId);
            this.databaseHelper.SetParameterToSQLCommand("@ModifiedBy ", userId);
            this.databaseHelper.SetParameterToSQLCommand("@InventoryData", inventoryData);

            SqlHelper.ParseNativeLong(this.databaseHelper.GetExecuteScalarByStoredProcedure("HMS_spU_BloodInventory").ToString());

        }

        #endregion

        #region Public Blood Bank

        public List<CompanyModel> GetHospitals(string bloodGroup)
        {
            try
            {
                this.databaseHelper = new DBHelper();

                this.databaseHelper.SetParameterToSQLCommand("@BloodGroup", bloodGroup);

                IDataReader dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spS_CompanyByBloodGroup");

                if (dataReader != null)
                {
                    using (dataReader)
                    {
                        CompanyModel company;
                        List<CompanyModel> companyList = new List<CompanyModel>();

                        while (dataReader.Read())
                        {
                            company = new CompanyModel();

                            company.CompanyId = SqlHelper.GetDBLongValue(dataReader["CompanyId"]);
                            company.CompanyName = SqlHelper.GetDBStringValue(dataReader["CompanyName"]);
                            company.Address1 = SqlHelper.GetDBStringValue(dataReader["Address1"]);
                            company.Address2 = SqlHelper.GetDBStringValue(dataReader["Address2"]);
                            company.City = SqlHelper.GetDBStringValue(dataReader["City"]);
                            company.State = SqlHelper.GetDBStringValue(dataReader["State"]);
                            company.ZipCode = SqlHelper.GetDBStringValue(dataReader["ZipCode"]);
                            company.Phone = SqlHelper.GetDBStringValue(dataReader["Phone"]);
                            company.Fax = SqlHelper.GetDBStringValue(dataReader["Fax"]);
                            company.Email = SqlHelper.GetDBStringValue(dataReader["Email"]);
                            company.IsActive = SqlHelper.GetDBBoolValue(dataReader["IsActive"]);

                            companyList.Add(company);
                        }

                        if (companyList.Count > 0)
                        {
                            dataReader.NextResult();

                            while (dataReader.Read())
                            {
                                companyList[0].TotalRecordCount = SqlHelper.GetDBIntValue(dataReader["TotalRecordCount"]);
                            }
                        }

                        return companyList;
                    }
                }
                else
                {
                    return null;
                }
            }
            catch
            {
                throw;
            }
            finally
            {
                this.databaseHelper.CloseConnection();
            }
        }

        #endregion

        #region Dispose Methods

        /// <summary>
        /// Performs application-defined tasks associated with freeing, releasing, or resetting unmanaged resources.
        /// </summary>
        public void Dispose()
        {
            this.Dispose(true);
        }

        /// <summary>
        /// Releases unmanaged and - optionally - managed resources.
        /// </summary>
        /// <param name="disposing"><c>true</c> to release both managed and unmanaged resources; <c>false</c> to release only unmanaged resources.</param>
        protected virtual void Dispose(bool disposing)
        {
            if (disposing)
            {
                this.databaseHelper.Dispose();
            }
        }

        #endregion
    }
}