﻿using System;
using System.Collections.Generic;
using System.Data;
using HMS.Class.Helper;
using HMS.Models;

namespace HMS.Class.DAL
{

    public class ExpenseCategoryDAL : IDisposable
    {
        #region Variable Declaration

        private DBHelper databaseHelper;

        #endregion

        #region ExpenseCategory

        #region Public Methods
        public List<ExpenseCategoryModel> GetAll( string searchField, string searchValue, string sortField, string sortOrder, int pageNo, int pageSize)
        {
            try
            {
                this.databaseHelper = new DBHelper();

                this.databaseHelper.SetParameterToSQLCommand("@SearchField", searchField);
                this.databaseHelper.SetParameterToSQLCommand("@SearchValue", searchValue);
                this.databaseHelper.SetParameterToSQLCommand("@SortField", sortField);
                this.databaseHelper.SetParameterToSQLCommand("@SortOrder", sortOrder);
                this.databaseHelper.SetParameterToSQLCommand("@PageNo", pageNo);
                this.databaseHelper.SetParameterToSQLCommand("@PageSize", pageSize);

                long companyId = SqlHelper.ParseNativeLong(CommonLogic.GetSessionValue(StringConstants.CompanyId));
                this.databaseHelper.SetParameterToSQLCommand("@CompanyId ", companyId);

                IDataReader dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spS_ExpenseCategory");

                return this.GetExpenseCategoryData(dataReader);
            }
            catch
            {
                throw;
            }
            finally
            {
                this.databaseHelper.CloseConnection();
            }
        }

        public ExpenseCategoryModel GetById(long expenseCategoryId)
        {
            try
            {
                this.databaseHelper = new DBHelper();

                this.databaseHelper.SetParameterToSQLCommand("@ExpenseCategoryId", expenseCategoryId);
                IDataReader dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spS_ExpenseCategoryById");

                List<ExpenseCategoryModel> list = this.GetExpenseCategoryData(dataReader);

                if (list != null && list.Count > 0)
                {
                    return list[0];
                }
                else
                {
                    return null;
                }
            }
            catch
            {
                throw;
            }
            finally
            {
                this.databaseHelper.CloseConnection();
            }
        }
      
        public ExpenseCategoryModel Save(ExpenseCategoryModel expenseCategory)
        {
            this.databaseHelper = new DBHelper();

            this.databaseHelper.SetParameterToSQLCommand("@ExpenseCategory", expenseCategory.ExpenseCategory);
            this.databaseHelper.SetParameterToSQLCommand("@Description", expenseCategory.Description);
            this.databaseHelper.SetParameterToSQLCommand("@IsActive", expenseCategory.IsActive);
            this.databaseHelper.SetParameterToSQLCommand("@CreatedBy", expenseCategory.CreatedBy);
            this.databaseHelper.SetParameterToSQLCommand("@CompanyId", expenseCategory.CompanyId);

            IDataReader dataReader;
            ExpenseCategoryModel tempUser = new ExpenseCategoryModel();

            if (expenseCategory.ExpenseCategoryId > 0)
            {
                this.databaseHelper.SetParameterToSQLCommand("@ExpenseCategoryId", expenseCategory.ExpenseCategoryId);
                dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spU_ExpenseCategory");
            }
            else
            {
                dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spI_ExpenseCategory");
            }

            if (dataReader != null)
            {
                using (dataReader)
                {
                    while (dataReader.Read())
                    {
                        tempUser.ExpenseCategoryId = SqlHelper.GetDBLongValue(dataReader["RETURNVAL"]);
                        tempUser.DuplicateColumn = SqlHelper.GetDBStringValue(dataReader["DuplicateColumn"]);
                    }

                    return tempUser;
                }
            }
            else
            {
                return null;
            }
        }

        public int UpdateMultipleRecords(MultiOperationType operationType, string multiIds)
        {
            this.databaseHelper = new DBHelper();

            this.databaseHelper.SetParameterToSQLCommand("@MultiIds", multiIds);
            this.databaseHelper.SetParameterToSQLCommand("@OperationType", (int)operationType);

            return SqlHelper.ParseNativeInt(this.databaseHelper.GetExecuteScalarByStoredProcedure("HMS_spM_ExpenseCategory").ToString());
        }

        #endregion

        #region Private Methods

        private List<ExpenseCategoryModel> GetExpenseCategoryData(IDataReader dataReader)
        {
            if (dataReader != null)
            {
                using (dataReader)
                {
                    ExpenseCategoryModel expenseCategory;
                    List<ExpenseCategoryModel> expenseCategoryList = new List<ExpenseCategoryModel>();

                    while (dataReader.Read())
                    {
                        expenseCategory = new ExpenseCategoryModel();

                        expenseCategory.ExpenseCategoryId = SqlHelper.GetDBLongValue(dataReader["ExpenseCategoryId"]);
                        expenseCategory.ExpenseCategory = SqlHelper.GetDBStringValue(dataReader["ExpenseCategory"]);
                        expenseCategory.Description = SqlHelper.GetDBStringValue(dataReader["Description"]);
                        expenseCategory.IsActive = SqlHelper.GetDBBoolValue(dataReader["IsActive"]);

                        expenseCategoryList.Add(expenseCategory);
                    }

                    if (expenseCategoryList.Count > 0)
                    {
                        dataReader.NextResult();

                        while (dataReader.Read())
                        {
                            expenseCategoryList[0].TotalRecordCount = SqlHelper.GetDBIntValue(dataReader["TotalRecordCount"]);
                        }
                    }

                    return expenseCategoryList;
                }
            }
            else
            {
                return null;
            }
        }
        #endregion

        #endregion

        #region Dispose Methods

        /// <summary>
        /// Performs application-defined tasks associated with freeing, releasing, or resetting unmanaged resources.
        /// </summary>
        public void Dispose()
        {
            this.Dispose(true);
        }

        /// <summary>
        /// Releases unmanaged and - optionally - managed resources.
        /// </summary>
        /// <param name="disposing"><c>true</c> to release both managed and unmanaged resources; <c>false</c> to release only unmanaged resources.</param>
        protected virtual void Dispose(bool disposing)
        {
            if (disposing)
            {
                this.databaseHelper.Dispose();
            }
        }

        #endregion
    }
}