﻿using System;
using System.Collections.Generic;
using System.Data;
using HMS.Class.Helper;
using HMS.Models;

namespace HMS.Class.DAL
{

    public class ExpenseDAL : IDisposable
    {
        #region Variable Declaration

        private DBHelper databaseHelper;

        #endregion

        #region Expense

        #region Public Methods
        public List<ExpenseModel> GetAll( string searchField, string searchValue, string sortField, string sortOrder, int pageNo, int pageSize)
        {
            try
            {
                this.databaseHelper = new DBHelper();

                this.databaseHelper.SetParameterToSQLCommand("@SearchField", searchField);
                this.databaseHelper.SetParameterToSQLCommand("@SearchValue", searchValue);
                this.databaseHelper.SetParameterToSQLCommand("@SortField", sortField);
                this.databaseHelper.SetParameterToSQLCommand("@SortOrder", sortOrder);
                this.databaseHelper.SetParameterToSQLCommand("@PageNo", pageNo);
                this.databaseHelper.SetParameterToSQLCommand("@PageSize", pageSize);

                long companyId = SqlHelper.ParseNativeLong(CommonLogic.GetSessionValue(StringConstants.CompanyId));
                this.databaseHelper.SetParameterToSQLCommand("@CompanyId ", companyId);

                IDataReader dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spS_Expense");

                return this.GetExpenseData(dataReader);
            }
            catch
            {
                throw;
            }
            finally
            {
                this.databaseHelper.CloseConnection();
            }
        }

        public ExpenseModel GetById(long medicineId)
        {
            try
            {
                this.databaseHelper = new DBHelper();

                this.databaseHelper.SetParameterToSQLCommand("@ExpenseId", medicineId);
                IDataReader dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spS_ExpenseById");

                List<ExpenseModel> list = this.GetExpenseData(dataReader);

                if (list != null && list.Count > 0)
                {
                    return list[0];
                }
                else
                {
                    return null;
                }
            }
            catch
            {
                throw;
            }
            finally
            {
                this.databaseHelper.CloseConnection();
            }
        }
      
        public ExpenseModel Save(ExpenseModel medicine)
        {
            this.databaseHelper = new DBHelper();

            this.databaseHelper.SetParameterToSQLCommand("@ExpenseCategoryId", medicine.ExpenseCategoryId);
            this.databaseHelper.SetParameterToSQLCommand("@ExpenseAmount", medicine.ExpenseAmount);
            this.databaseHelper.SetParameterToSQLCommand("@CreatedBy", medicine.CreatedBy);
            this.databaseHelper.SetParameterToSQLCommand("@CompanyId", medicine.CompanyId);

            IDataReader dataReader;
            ExpenseModel tempUser = new ExpenseModel();

            if (medicine.ExpenseId > 0)
            {
                this.databaseHelper.SetParameterToSQLCommand("@ExpenseId", medicine.ExpenseId);
                dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spU_Expense");
            }
            else
            {
                dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spI_Expense");
            }

            if (dataReader != null)
            {
                using (dataReader)
                {
                    while (dataReader.Read())
                    {
                        tempUser.ExpenseId = SqlHelper.GetDBLongValue(dataReader["RETURNVAL"]);
                        tempUser.DuplicateColumn = SqlHelper.GetDBStringValue(dataReader["DuplicateColumn"]);
                    }

                    return tempUser;
                }
            }
            else
            {
                return null;
            }
        }

        public int UpdateMultipleRecords(MultiOperationType operationType, string multiIds)
        {
            this.databaseHelper = new DBHelper();

            this.databaseHelper.SetParameterToSQLCommand("@MultiIds", multiIds);
            this.databaseHelper.SetParameterToSQLCommand("@OperationType", (int)operationType);

            return SqlHelper.ParseNativeInt(this.databaseHelper.GetExecuteScalarByStoredProcedure("HMS_spM_Expense").ToString());
        }

        #endregion

        #region Private Methods

        private List<ExpenseModel> GetExpenseData(IDataReader dataReader)
        {
            if (dataReader != null)
            {
                using (dataReader)
                {
                    ExpenseModel medicine;
                    List<ExpenseModel> medicineList = new List<ExpenseModel>();

                    while (dataReader.Read())
                    {
                        medicine = new ExpenseModel();

                        medicine.ExpenseId = SqlHelper.GetDBLongValue(dataReader["ExpenseId"]);
                        medicine.ExpenseAmount = SqlHelper.GetDBDecimalValue(dataReader["ExpenseAmount"]);
                        medicine.ExpenseDate = SqlHelper.GetDBDateTimeValue(dataReader["ExpenseDate"]);
                        medicine.ExpenseCategoryId = SqlHelper.GetDBLongValue(dataReader["ExpenseCategoryId"]);
                        medicine.ExpenseCategory = SqlHelper.GetDBStringValue(dataReader["ExpenseCategory"]);

                        medicineList.Add(medicine);
                    }

                    if (medicineList.Count > 0)
                    {
                        dataReader.NextResult();

                        while (dataReader.Read())
                        {
                            medicineList[0].TotalRecordCount = SqlHelper.GetDBIntValue(dataReader["TotalRecordCount"]);
                        }
                    }

                    return medicineList;
                }
            }
            else
            {
                return null;
            }
        }
        #endregion

        #endregion

        #region Dispose Methods

        /// <summary>
        /// Performs application-defined tasks associated with freeing, releasing, or resetting unmanaged resources.
        /// </summary>
        public void Dispose()
        {
            this.Dispose(true);
        }

        /// <summary>
        /// Releases unmanaged and - optionally - managed resources.
        /// </summary>
        /// <param name="disposing"><c>true</c> to release both managed and unmanaged resources; <c>false</c> to release only unmanaged resources.</param>
        protected virtual void Dispose(bool disposing)
        {
            if (disposing)
            {
                this.databaseHelper.Dispose();
            }
        }

        #endregion
    }
}