﻿using System;
using System.Collections.Generic;
using System.Data;
using HMS.Class.Helper;
using HMS.Models;

namespace HMS.Class.DAL
{

    public class LabTestCategoryDAL : IDisposable
    {
        #region Variable Declaration

        private DBHelper databaseHelper;

        #endregion

        #region LabTestCategory

        #region Public Methods
        public List<LabTestCategoryModel> GetAll( string searchField, string searchValue, string sortField, string sortOrder, int pageNo, int pageSize)
        {
            try
            {
                this.databaseHelper = new DBHelper();

                this.databaseHelper.SetParameterToSQLCommand("@SearchField", searchField);
                this.databaseHelper.SetParameterToSQLCommand("@SearchValue", searchValue);
                this.databaseHelper.SetParameterToSQLCommand("@SortField", sortField);
                this.databaseHelper.SetParameterToSQLCommand("@SortOrder", sortOrder);
                this.databaseHelper.SetParameterToSQLCommand("@PageNo", pageNo);
                this.databaseHelper.SetParameterToSQLCommand("@PageSize", pageSize);

                long companyId = SqlHelper.ParseNativeLong(CommonLogic.GetSessionValue(StringConstants.CompanyId));
                this.databaseHelper.SetParameterToSQLCommand("@CompanyId ", companyId);

                IDataReader dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spS_LabTestCategory");

                return this.GetLabTestCategoryData(dataReader);
            }
            catch
            {
                throw;
            }
            finally
            {
                this.databaseHelper.CloseConnection();
            }
        }

        public LabTestCategoryModel GetById(long labTestCategoryId)
        {
            try
            {
                this.databaseHelper = new DBHelper();

                this.databaseHelper.SetParameterToSQLCommand("@LabTestCategoryId", labTestCategoryId);
                IDataReader dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spS_LabTestCategoryById");

                List<LabTestCategoryModel> list = this.GetLabTestCategoryData(dataReader);

                if (list != null && list.Count > 0)
                {
                    return list[0];
                }
                else
                {
                    return null;
                }
            }
            catch
            {
                throw;
            }
            finally
            {
                this.databaseHelper.CloseConnection();
            }
        }
      
        public LabTestCategoryModel Save(LabTestCategoryModel labTestCategory)
        {
            this.databaseHelper = new DBHelper();

            this.databaseHelper.SetParameterToSQLCommand("@LabTestCategoryName", labTestCategory.LabTestCategoryName);
            this.databaseHelper.SetParameterToSQLCommand("@Description", labTestCategory.Description);
            this.databaseHelper.SetParameterToSQLCommand("@IsActive", labTestCategory.IsActive);
            this.databaseHelper.SetParameterToSQLCommand("@CreatedBy", labTestCategory.CreatedBy);
            this.databaseHelper.SetParameterToSQLCommand("@CompanyId", labTestCategory.CompanyId);

            IDataReader dataReader;
            LabTestCategoryModel tempUser = new LabTestCategoryModel();

            if (labTestCategory.LabTestCategoryId > 0)
            {
                this.databaseHelper.SetParameterToSQLCommand("@LabTestCategoryId", labTestCategory.LabTestCategoryId);
                dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spU_LabTestCategory");
            }
            else
            {
                dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spI_LabTestCategory");
            }

            if (dataReader != null)
            {
                using (dataReader)
                {
                    while (dataReader.Read())
                    {
                        tempUser.LabTestCategoryId = SqlHelper.GetDBLongValue(dataReader["RETURNVAL"]);
                        tempUser.DuplicateColumn = SqlHelper.GetDBStringValue(dataReader["DuplicateColumn"]);
                    }

                    return tempUser;
                }
            }
            else
            {
                return null;
            }
        }

        public int UpdateMultipleRecords(MultiOperationType operationType, string multiIds)
        {
            this.databaseHelper = new DBHelper();

            this.databaseHelper.SetParameterToSQLCommand("@MultiIds", multiIds);
            this.databaseHelper.SetParameterToSQLCommand("@OperationType", (int)operationType);

            return SqlHelper.ParseNativeInt(this.databaseHelper.GetExecuteScalarByStoredProcedure("HMS_spM_LabTestCategory").ToString());
        }

        #endregion

        #region Private Methods

        private List<LabTestCategoryModel> GetLabTestCategoryData(IDataReader dataReader)
        {
            if (dataReader != null)
            {
                using (dataReader)
                {
                    LabTestCategoryModel labTestCategory;
                    List<LabTestCategoryModel> labTestCategoryList = new List<LabTestCategoryModel>();

                    while (dataReader.Read())
                    {
                        labTestCategory = new LabTestCategoryModel();

                        labTestCategory.LabTestCategoryId = SqlHelper.GetDBLongValue(dataReader["LabTestCategoryId"]);
                        labTestCategory.LabTestCategoryName = SqlHelper.GetDBStringValue(dataReader["LabTestCategoryName"]);
                        labTestCategory.Description = SqlHelper.GetDBStringValue(dataReader["Description"]);
                        labTestCategory.IsActive = SqlHelper.GetDBBoolValue(dataReader["IsActive"]);

                        labTestCategoryList.Add(labTestCategory);
                    }

                    if (labTestCategoryList.Count > 0)
                    {
                        dataReader.NextResult();

                        while (dataReader.Read())
                        {
                            labTestCategoryList[0].TotalRecordCount = SqlHelper.GetDBIntValue(dataReader["TotalRecordCount"]);
                        }
                    }

                    return labTestCategoryList;
                }
            }
            else
            {
                return null;
            }
        }
        #endregion

        #endregion

        #region Dispose Methods

        /// <summary>
        /// Performs application-defined tasks associated with freeing, releasing, or resetting unmanaged resources.
        /// </summary>
        public void Dispose()
        {
            this.Dispose(true);
        }

        /// <summary>
        /// Releases unmanaged and - optionally - managed resources.
        /// </summary>
        /// <param name="disposing"><c>true</c> to release both managed and unmanaged resources; <c>false</c> to release only unmanaged resources.</param>
        protected virtual void Dispose(bool disposing)
        {
            if (disposing)
            {
                this.databaseHelper.Dispose();
            }
        }

        #endregion
    }
}