﻿using System;
using System.Collections.Generic;
using System.Data;
using HMS.Class.Helper;
using HMS.Models;

namespace HMS.Class.DAL
{

    public class LabTestDAL : IDisposable
    {
        #region Variable Declaration

        private DBHelper databaseHelper;

        #endregion

        #region LabTest

        #region Public Methods
        public List<LabTestModel> GetAll( string searchField, string searchValue, string sortField, string sortOrder, int pageNo, int pageSize)
        {
            try
            {
                this.databaseHelper = new DBHelper();

                this.databaseHelper.SetParameterToSQLCommand("@SearchField", searchField);
                this.databaseHelper.SetParameterToSQLCommand("@SearchValue", searchValue);
                this.databaseHelper.SetParameterToSQLCommand("@SortField", sortField);
                this.databaseHelper.SetParameterToSQLCommand("@SortOrder", sortOrder);
                this.databaseHelper.SetParameterToSQLCommand("@PageNo", pageNo);
                this.databaseHelper.SetParameterToSQLCommand("@PageSize", pageSize);

                long companyId = SqlHelper.ParseNativeLong(CommonLogic.GetSessionValue(StringConstants.CompanyId));
                this.databaseHelper.SetParameterToSQLCommand("@CompanyId ", companyId);

                IDataReader dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spS_LabTest");

                return this.GetLabTestData(dataReader);
            }
            catch
            {
                throw;
            }
            finally
            {
                this.databaseHelper.CloseConnection();
            }
        }

        public LabTestModel GetById(long labTestId)
        {
            try
            {
                this.databaseHelper = new DBHelper();

                this.databaseHelper.SetParameterToSQLCommand("@LabTestId", labTestId);
                IDataReader dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spS_LabTestById");

                List<LabTestModel> list = this.GetLabTestData(dataReader);

                if (list != null && list.Count > 0)
                {
                    return list[0];
                }
                else
                {
                    return null;
                }
            }
            catch
            {
                throw;
            }
            finally
            {
                this.databaseHelper.CloseConnection();
            }
        }
      
        public LabTestModel Save(LabTestModel labTest)
        {
            this.databaseHelper = new DBHelper();

            this.databaseHelper.SetParameterToSQLCommand("@LabTestCategoryId", labTest.LabTestCategoryId);
            this.databaseHelper.SetParameterToSQLCommand("@LabTestName", labTest.LabTestName);
            this.databaseHelper.SetParameterToSQLCommand("@TestUnit", labTest.TestUnit);
            this.databaseHelper.SetParameterToSQLCommand("@ReferenceRange", labTest.ReferenceRange);
            this.databaseHelper.SetParameterToSQLCommand("@IsActive", labTest.IsActive);
            this.databaseHelper.SetParameterToSQLCommand("@CreatedBy", labTest.CreatedBy);
            this.databaseHelper.SetParameterToSQLCommand("@CompanyId", labTest.CompanyId);

            IDataReader dataReader;
            LabTestModel tempUser = new LabTestModel();

            if (labTest.LabTestId > 0)
            {
                this.databaseHelper.SetParameterToSQLCommand("@LabTestId", labTest.LabTestId);
                dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spU_LabTest");
            }
            else
            {
                dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spI_LabTest");
            }

            if (dataReader != null)
            {
                using (dataReader)
                {
                    while (dataReader.Read())
                    {
                        tempUser.LabTestId = SqlHelper.GetDBLongValue(dataReader["RETURNVAL"]);
                        tempUser.DuplicateColumn = SqlHelper.GetDBStringValue(dataReader["DuplicateColumn"]);
                    }

                    return tempUser;
                }
            }
            else
            {
                return null;
            }
        }

        public int UpdateMultipleRecords(MultiOperationType operationType, string multiIds)
        {
            this.databaseHelper = new DBHelper();

            this.databaseHelper.SetParameterToSQLCommand("@MultiIds", multiIds);
            this.databaseHelper.SetParameterToSQLCommand("@OperationType", (int)operationType);

            return SqlHelper.ParseNativeInt(this.databaseHelper.GetExecuteScalarByStoredProcedure("HMS_spM_LabTest").ToString());
        }

        #endregion

        #region Private Methods

        private List<LabTestModel> GetLabTestData(IDataReader dataReader)
        {
            if (dataReader != null)
            {
                using (dataReader)
                {
                    LabTestModel labTest;
                    List<LabTestModel> labTestList = new List<LabTestModel>();

                    while (dataReader.Read())
                    {
                        labTest = new LabTestModel();

                        labTest.LabTestId = SqlHelper.GetDBLongValue(dataReader["LabTestId"]);
                        labTest.LabTestName = SqlHelper.GetDBStringValue(dataReader["LabTestName"]);
                        labTest.TestUnit = SqlHelper.GetDBStringValue(dataReader["TestUnit"]);
                        labTest.ReferenceRange = SqlHelper.GetDBStringValue(dataReader["ReferenceRange"]);
                        labTest.IsActive = SqlHelper.GetDBBoolValue(dataReader["IsActive"]);
                        labTest.LabTestCategoryId = SqlHelper.GetDBLongValue(dataReader["LabTestCategoryId"]);
                        labTest.LabTestCategoryName = SqlHelper.GetDBStringValue(dataReader["LabTestCategoryName"]);

                        labTestList.Add(labTest);
                    }

                    if (labTestList.Count > 0)
                    {
                        dataReader.NextResult();

                        while (dataReader.Read())
                        {
                            labTestList[0].TotalRecordCount = SqlHelper.GetDBIntValue(dataReader["TotalRecordCount"]);
                        }
                    }

                    return labTestList;
                }
            }
            else
            {
                return null;
            }
        }
        #endregion

        #endregion

        #region Dispose Methods

        /// <summary>
        /// Performs application-defined tasks associated with freeing, releasing, or resetting unmanaged resources.
        /// </summary>
        public void Dispose()
        {
            this.Dispose(true);
        }

        /// <summary>
        /// Releases unmanaged and - optionally - managed resources.
        /// </summary>
        /// <param name="disposing"><c>true</c> to release both managed and unmanaged resources; <c>false</c> to release only unmanaged resources.</param>
        protected virtual void Dispose(bool disposing)
        {
            if (disposing)
            {
                this.databaseHelper.Dispose();
            }
        }

        #endregion
    }
}
