﻿using System;
using System.Collections.Generic;
using System.Data;
using HMS.Class.Helper;
using HMS.Models;

namespace HMS.Class.DAL
{

    public class MedicineCategoryDAL : IDisposable
    {
        #region Variable Declaration

        private DBHelper databaseHelper;

        #endregion

        #region MedicineCategory

        #region Public Methods
        public List<MedicineCategoryModel> GetAll( string searchField, string searchValue, string sortField, string sortOrder, int pageNo, int pageSize)
        {
            try
            {
                this.databaseHelper = new DBHelper();

                this.databaseHelper.SetParameterToSQLCommand("@SearchField", searchField);
                this.databaseHelper.SetParameterToSQLCommand("@SearchValue", searchValue);
                this.databaseHelper.SetParameterToSQLCommand("@SortField", sortField);
                this.databaseHelper.SetParameterToSQLCommand("@SortOrder", sortOrder);
                this.databaseHelper.SetParameterToSQLCommand("@PageNo", pageNo);
                this.databaseHelper.SetParameterToSQLCommand("@PageSize", pageSize);

                long companyId = SqlHelper.ParseNativeLong(CommonLogic.GetSessionValue(StringConstants.CompanyId));
                this.databaseHelper.SetParameterToSQLCommand("@CompanyId ", companyId);

                IDataReader dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spS_MedicineCategory");

                return this.GetMedicineCategoryData(dataReader);
            }
            catch
            {
                throw;
            }
            finally
            {
                this.databaseHelper.CloseConnection();
            }
        }

        public MedicineCategoryModel GetById(long medicineCategoryId)
        {
            try
            {
                this.databaseHelper = new DBHelper();

                this.databaseHelper.SetParameterToSQLCommand("@MedicineCategoryId", medicineCategoryId);
                IDataReader dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spS_MedicineCategoryById");

                List<MedicineCategoryModel> list = this.GetMedicineCategoryData(dataReader);

                if (list != null && list.Count > 0)
                {
                    return list[0];
                }
                else
                {
                    return null;
                }
            }
            catch
            {
                throw;
            }
            finally
            {
                this.databaseHelper.CloseConnection();
            }
        }
      
        public MedicineCategoryModel Save(MedicineCategoryModel medicineCategory)
        {
            this.databaseHelper = new DBHelper();

            this.databaseHelper.SetParameterToSQLCommand("@MedicineCategory", medicineCategory.MedicineCategory);
            this.databaseHelper.SetParameterToSQLCommand("@IsActive", medicineCategory.IsActive);
            this.databaseHelper.SetParameterToSQLCommand("@CreatedBy", medicineCategory.CreatedBy);
            this.databaseHelper.SetParameterToSQLCommand("@CompanyId", medicineCategory.CompanyId);

            IDataReader dataReader;
            MedicineCategoryModel tempUser = new MedicineCategoryModel();

            if (medicineCategory.MedicineCategoryId > 0)
            {
                this.databaseHelper.SetParameterToSQLCommand("@MedicineCategoryId", medicineCategory.MedicineCategoryId);
                dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spU_MedicineCategory");
            }
            else
            {
                dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spI_MedicineCategory");
            }

            if (dataReader != null)
            {
                using (dataReader)
                {
                    while (dataReader.Read())
                    {
                        tempUser.MedicineCategoryId = SqlHelper.GetDBLongValue(dataReader["RETURNVAL"]);
                        tempUser.DuplicateColumn = SqlHelper.GetDBStringValue(dataReader["DuplicateColumn"]);
                    }

                    return tempUser;
                }
            }
            else
            {
                return null;
            }
        }

        public int UpdateMultipleRecords(MultiOperationType operationType, string multiIds)
        {
            this.databaseHelper = new DBHelper();

            this.databaseHelper.SetParameterToSQLCommand("@MultiIds", multiIds);
            this.databaseHelper.SetParameterToSQLCommand("@OperationType", (int)operationType);

            return SqlHelper.ParseNativeInt(this.databaseHelper.GetExecuteScalarByStoredProcedure("HMS_spM_MedicineCategory").ToString());
        }

        #endregion

        #region Private Methods

        private List<MedicineCategoryModel> GetMedicineCategoryData(IDataReader dataReader)
        {
            if (dataReader != null)
            {
                using (dataReader)
                {
                    MedicineCategoryModel medicineCategory;
                    List<MedicineCategoryModel> medicineCategoryList = new List<MedicineCategoryModel>();

                    while (dataReader.Read())
                    {
                        medicineCategory = new MedicineCategoryModel();

                        medicineCategory.MedicineCategoryId = SqlHelper.GetDBLongValue(dataReader["MedicineCategoryId"]);
                        medicineCategory.MedicineCategory = SqlHelper.GetDBStringValue(dataReader["MedicineCategory"]);
                        medicineCategory.IsActive = SqlHelper.GetDBBoolValue(dataReader["IsActive"]);

                        medicineCategoryList.Add(medicineCategory);
                    }

                    if (medicineCategoryList.Count > 0)
                    {
                        dataReader.NextResult();

                        while (dataReader.Read())
                        {
                            medicineCategoryList[0].TotalRecordCount = SqlHelper.GetDBIntValue(dataReader["TotalRecordCount"]);
                        }
                    }

                    return medicineCategoryList;
                }
            }
            else
            {
                return null;
            }
        }
        #endregion

        #endregion

        #region Dispose Methods

        /// <summary>
        /// Performs application-defined tasks associated with freeing, releasing, or resetting unmanaged resources.
        /// </summary>
        public void Dispose()
        {
            this.Dispose(true);
        }

        /// <summary>
        /// Releases unmanaged and - optionally - managed resources.
        /// </summary>
        /// <param name="disposing"><c>true</c> to release both managed and unmanaged resources; <c>false</c> to release only unmanaged resources.</param>
        protected virtual void Dispose(bool disposing)
        {
            if (disposing)
            {
                this.databaseHelper.Dispose();
            }
        }

        #endregion
    }
}