﻿using System;
using System.Collections.Generic;
using System.Data;
using HMS.Class.Helper;
using HMS.Models;

namespace HMS.Class.DAL
{

    public class MedicineDAL : IDisposable
    {
        #region Variable Declaration

        private DBHelper databaseHelper;

        #endregion

        #region Medicine

        #region Public Methods
        public List<MedicineModel> GetAll( string searchField, string searchValue, string sortField, string sortOrder, int pageNo, int pageSize)
        {
            try
            {
                this.databaseHelper = new DBHelper();

                this.databaseHelper.SetParameterToSQLCommand("@SearchField", searchField);
                this.databaseHelper.SetParameterToSQLCommand("@SearchValue", searchValue);
                this.databaseHelper.SetParameterToSQLCommand("@SortField", sortField);
                this.databaseHelper.SetParameterToSQLCommand("@SortOrder", sortOrder);
                this.databaseHelper.SetParameterToSQLCommand("@PageNo", pageNo);
                this.databaseHelper.SetParameterToSQLCommand("@PageSize", pageSize);

                long companyId = SqlHelper.ParseNativeLong(CommonLogic.GetSessionValue(StringConstants.CompanyId));
                this.databaseHelper.SetParameterToSQLCommand("@CompanyId ", companyId);

                IDataReader dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spS_Medicine");

                return this.GetMedicineData(dataReader);
            }
            catch
            {
                throw;
            }
            finally
            {
                this.databaseHelper.CloseConnection();
            }
        }

        public MedicineModel GetById(long medicineId)
        {
            try
            {
                this.databaseHelper = new DBHelper();

                this.databaseHelper.SetParameterToSQLCommand("@MedicineId", medicineId);
                IDataReader dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spS_MedicineById");

                List<MedicineModel> list = this.GetMedicineData(dataReader);

                if (list != null && list.Count > 0)
                {
                    return list[0];
                }
                else
                {
                    return null;
                }
            }
            catch
            {
                throw;
            }
            finally
            {
                this.databaseHelper.CloseConnection();
            }
        }
      
        public MedicineModel Save(MedicineModel medicine)
        {
            this.databaseHelper = new DBHelper();

            this.databaseHelper.SetParameterToSQLCommand("@MedicineName", medicine.MedicineName);
            this.databaseHelper.SetParameterToSQLCommand("@Description", medicine.Description);
            this.databaseHelper.SetParameterToSQLCommand("@MedicineCategoryId", medicine.MedicineCategoryId);
            this.databaseHelper.SetParameterToSQLCommand("@IsActive", medicine.IsActive);
            this.databaseHelper.SetParameterToSQLCommand("@CreatedBy", medicine.CreatedBy);
            this.databaseHelper.SetParameterToSQLCommand("@CompanyId", medicine.CompanyId);

            IDataReader dataReader;
            MedicineModel tempUser = new MedicineModel();

            if (medicine.MedicineId > 0)
            {
                this.databaseHelper.SetParameterToSQLCommand("@MedicineId", medicine.MedicineId);
                dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spU_Medicine");
            }
            else
            {
                dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spI_Medicine");
            }

            if (dataReader != null)
            {
                using (dataReader)
                {
                    while (dataReader.Read())
                    {
                        tempUser.MedicineId = SqlHelper.GetDBLongValue(dataReader["RETURNVAL"]);
                        tempUser.DuplicateColumn = SqlHelper.GetDBStringValue(dataReader["DuplicateColumn"]);
                    }

                    return tempUser;
                }
            }
            else
            {
                return null;
            }
        }

        public int UpdateMultipleRecords(MultiOperationType operationType, string multiIds)
        {
            this.databaseHelper = new DBHelper();

            this.databaseHelper.SetParameterToSQLCommand("@MultiIds", multiIds);
            this.databaseHelper.SetParameterToSQLCommand("@OperationType", (int)operationType);

            return SqlHelper.ParseNativeInt(this.databaseHelper.GetExecuteScalarByStoredProcedure("HMS_spM_Medicine").ToString());
        }

        #endregion

        #region Private Methods

        private List<MedicineModel> GetMedicineData(IDataReader dataReader)
        {
            if (dataReader != null)
            {
                using (dataReader)
                {
                    MedicineModel medicine;
                    List<MedicineModel> medicineList = new List<MedicineModel>();

                    while (dataReader.Read())
                    {
                        medicine = new MedicineModel();

                        medicine.MedicineId = SqlHelper.GetDBLongValue(dataReader["MedicineId"]);
                        medicine.MedicineName = SqlHelper.GetDBStringValue(dataReader["MedicineName"]);
                        medicine.Description = SqlHelper.GetDBStringValue(dataReader["Description"]);
                        medicine.MedicineCategoryId = SqlHelper.GetDBLongValue(dataReader["MedicineCategoryId"]);
                        medicine.MedicineCategory = SqlHelper.GetDBStringValue(dataReader["MedicineCategory"]);
                        medicine.IsActive = SqlHelper.GetDBBoolValue(dataReader["IsActive"]);

                        medicineList.Add(medicine);
                    }

                    if (medicineList.Count > 0)
                    {
                        dataReader.NextResult();

                        while (dataReader.Read())
                        {
                            medicineList[0].TotalRecordCount = SqlHelper.GetDBIntValue(dataReader["TotalRecordCount"]);
                        }
                    }

                    return medicineList;
                }
            }
            else
            {
                return null;
            }
        }
        #endregion

        #endregion

        #region Dispose Methods

        /// <summary>
        /// Performs application-defined tasks associated with freeing, releasing, or resetting unmanaged resources.
        /// </summary>
        public void Dispose()
        {
            this.Dispose(true);
        }

        /// <summary>
        /// Releases unmanaged and - optionally - managed resources.
        /// </summary>
        /// <param name="disposing"><c>true</c> to release both managed and unmanaged resources; <c>false</c> to release only unmanaged resources.</param>
        protected virtual void Dispose(bool disposing)
        {
            if (disposing)
            {
                this.databaseHelper.Dispose();
            }
        }

        #endregion
    }
}