﻿using System;
using System.Collections.Generic;
using System.Data;
using HMS.Class.Helper;
using HMS.Models;

namespace HMS.Class.DAL
{

    public class PatientTestDAL : IDisposable
    {
        #region Variable Declaration

        private DBHelper databaseHelper;

        #endregion

        #region PatientTest

        #region Public Methods
        public List<PatientTestModel> GetAll( string searchField, string searchValue, string sortField, string sortOrder, int pageNo, int pageSize)
        {
            try
            {
                this.databaseHelper = new DBHelper();

                this.databaseHelper.SetParameterToSQLCommand("@SearchField", searchField);
                this.databaseHelper.SetParameterToSQLCommand("@SearchValue", searchValue);
                this.databaseHelper.SetParameterToSQLCommand("@SortField", sortField);
                this.databaseHelper.SetParameterToSQLCommand("@SortOrder", sortOrder);
                this.databaseHelper.SetParameterToSQLCommand("@PageNo", pageNo);
                this.databaseHelper.SetParameterToSQLCommand("@PageSize", pageSize);

                long companyId = SqlHelper.ParseNativeLong(CommonLogic.GetSessionValue(StringConstants.CompanyId));
                this.databaseHelper.SetParameterToSQLCommand("@CompanyId ", companyId);

                IDataReader dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spS_PatientTest");

                return this.GetPatientTestData(dataReader);
            }
            catch
            {
                throw;
            }
            finally
            {
                this.databaseHelper.CloseConnection();
            }
        }

        public PatientTestModel GetById(long patientTestId)
        {
            try
            {
                this.databaseHelper = new DBHelper();

                this.databaseHelper.SetParameterToSQLCommand("@PatientTestId", patientTestId);
                IDataReader dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spS_PatientTestById");

                List<PatientTestModel> list = this.GetPatientTestData(dataReader);

                if (list != null && list.Count > 0)
                {
                    return list[0];
                }
                else
                {
                    return null;
                }
            }
            catch
            {
                throw;
            }
            finally
            {
                this.databaseHelper.CloseConnection();
            }
        }
      
        public long Save(PatientTestModel patientTest)
        {
            this.databaseHelper = new DBHelper();

            this.databaseHelper.SetParameterToSQLCommand("@PatientId", patientTest.PatientId);
            this.databaseHelper.SetParameterToSQLCommand("@ConsultantId", patientTest.ConsultantId);
            this.databaseHelper.SetParameterToSQLCommand("@TestDate", patientTest.TestDate);
            this.databaseHelper.SetParameterToSQLCommand("@DeliveryDate", patientTest.DeliveryDate);
            this.databaseHelper.SetParameterToSQLCommand("@ReportStatus", patientTest.ReportStatus);
            this.databaseHelper.SetParameterToSQLCommand("@CreatedBy", patientTest.CreatedBy);
            this.databaseHelper.SetParameterToSQLCommand("@CompanyId", patientTest.CompanyId);

            if (patientTest.PatientTestId > 0)
            {
                this.databaseHelper.SetParameterToSQLCommand("@PatientTestId", patientTest.PatientTestId);
                return SqlHelper.ParseNativeLong(this.databaseHelper.GetExecuteScalarByStoredProcedure("HMS_spU_PatientTest").ToString());
            }
            else
            {
                return SqlHelper.ParseNativeLong(this.databaseHelper.GetExecuteScalarByStoredProcedure("HMS_spI_PatientTest").ToString());
            }
        }

        public int UpdateMultipleRecords(MultiOperationType operationType, string multiIds)
        {
            this.databaseHelper = new DBHelper();

            this.databaseHelper.SetParameterToSQLCommand("@MultiIds", multiIds);
            this.databaseHelper.SetParameterToSQLCommand("@OperationType", (int)operationType);

            return SqlHelper.ParseNativeInt(this.databaseHelper.GetExecuteScalarByStoredProcedure("HMS_spM_PatientTest").ToString());
        }

        public int UpdatePatientTestStatus(PatientTestStatusType patientTestStatusType, string multiIds)
        {
            this.databaseHelper = new DBHelper();

            this.databaseHelper.SetParameterToSQLCommand("@MultiIds", multiIds);
            this.databaseHelper.SetParameterToSQLCommand("@OperationType", (int)patientTestStatusType);

            return SqlHelper.ParseNativeInt(this.databaseHelper.GetExecuteScalarByStoredProcedure("HMS_spM_PatientTest").ToString());
        }

        #endregion

        #region PatientTest Detail

        public List<PatientTestDetailModel> GetPatientTestDetailByPatientTest(long patientTestId)
        {
         
            try
            {
                this.databaseHelper = new DBHelper();

                this.databaseHelper.SetParameterToSQLCommand("@PatientTestId", patientTestId);
               
                IDataReader dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spS_PatientTestDetailByPatientTestId");


                if (dataReader != null)
                {
                    using (dataReader)
                    {
                        PatientTestDetailModel patientTestDetail;
                        List<PatientTestDetailModel> patientTestDetailList = new List<PatientTestDetailModel>();

                        while (dataReader.Read())
                        {
                            patientTestDetail = new PatientTestDetailModel();

                            patientTestDetail.PatientTestId = SqlHelper.GetDBLongValue(dataReader["PatientTestId"]);
                            patientTestDetail.LabTestId = SqlHelper.GetDBLongValue(dataReader["LabTestId"]);
                            patientTestDetail.Result = SqlHelper.GetDBStringValue(dataReader["Result"]);
                            patientTestDetail.Remarks = SqlHelper.GetDBStringValue(dataReader["Remarks"]);

                            patientTestDetailList.Add(patientTestDetail);
                        }

                        return patientTestDetailList;
                    }
                }
                else
                {
                    return null;
                }
            }
            catch
            {
                throw;
            }
            finally
            {
                this.databaseHelper.CloseConnection();
            }
        }

        public void SavePatientTestDetail(long patientTestId, string testData)
        {
            this.databaseHelper = new DBHelper();

            this.databaseHelper.SetParameterToSQLCommand("@PatientTestId", patientTestId);
            this.databaseHelper.SetParameterToSQLCommand("@TestData", testData);

            SqlHelper.ParseNativeLong(this.databaseHelper.GetExecuteScalarByStoredProcedure("HMS_spU_PatientTestDetail").ToString());

        }
        #endregion

        #region Private Methods

        private List<PatientTestModel> GetPatientTestData(IDataReader dataReader)
        {
            if (dataReader != null)
            {
                using (dataReader)
                {
                    PatientTestModel patientTest;
                    List<PatientTestModel> patientTestList = new List<PatientTestModel>();

                    while (dataReader.Read())
                    {
                        patientTest = new PatientTestModel();

                        patientTest.PatientTestId = SqlHelper.GetDBLongValue(dataReader["PatientTestId"]);
                        patientTest.PatientId = SqlHelper.GetDBLongValue(dataReader["PatientId"]);
                        patientTest.CompanyId = SqlHelper.GetDBLongValue(dataReader["CompanyId"]);
                        patientTest.ConsultantId = SqlHelper.GetDBLongValue(dataReader["ConsultantId"]);
                        patientTest.TestDate = SqlHelper.GetDBDateTimeValue(dataReader["TestDate"]);
                        patientTest.DeliveryDate = SqlHelper.GetDBDateTimeValue(dataReader["DeliveryDate"]);
                        patientTest.ReportStatus = SqlHelper.GetDBIntValue(dataReader["ReportStatus"]);
                        patientTest.PatientName = SqlHelper.GetDBStringValue(dataReader["PatientName"]);
                
                        patientTestList.Add(patientTest);
                    }

                    if (patientTestList.Count > 0)
                    {
                        dataReader.NextResult();

                        while (dataReader.Read())
                        {
                            patientTestList[0].TotalRecordCount = SqlHelper.GetDBIntValue(dataReader["TotalRecordCount"]);
                        }
                    }

                    return patientTestList;
                }
            }
            else
            {
                return null;
            }
        }
        #endregion

        #endregion

        #region Dispose Methods

        /// <summary>
        /// Performs application-defined tasks associated with freeing, releasing, or resetting unmanaged resources.
        /// </summary>
        public void Dispose()
        {
            this.Dispose(true);
        }

        /// <summary>
        /// Releases unmanaged and - optionally - managed resources.
        /// </summary>
        /// <param name="disposing"><c>true</c> to release both managed and unmanaged resources; <c>false</c> to release only unmanaged resources.</param>
        protected virtual void Dispose(bool disposing)
        {
            if (disposing)
            {
                this.databaseHelper.Dispose();
            }
        }

        #endregion
    }
}