﻿using System;
using System.Collections.Generic;
using System.Data;
using HMS.Class.Helper;
using HMS.Models;

namespace HMS.Class.DAL
{

    public class PaymentCategoryDAL : IDisposable
    {
        #region Variable Declaration

        private DBHelper databaseHelper;

        #endregion

        #region PaymentCategory

        #region Public Methods
        public List<PaymentCategoryModel> GetAll( string searchField, string searchValue, string sortField, string sortOrder, int pageNo, int pageSize)
        {
            try
            {
                this.databaseHelper = new DBHelper();

                this.databaseHelper.SetParameterToSQLCommand("@SearchField", searchField);
                this.databaseHelper.SetParameterToSQLCommand("@SearchValue", searchValue);
                this.databaseHelper.SetParameterToSQLCommand("@SortField", sortField);
                this.databaseHelper.SetParameterToSQLCommand("@SortOrder", sortOrder);
                this.databaseHelper.SetParameterToSQLCommand("@PageNo", pageNo);
                this.databaseHelper.SetParameterToSQLCommand("@PageSize", pageSize);

                long companyId = SqlHelper.ParseNativeLong(CommonLogic.GetSessionValue(StringConstants.CompanyId));
                this.databaseHelper.SetParameterToSQLCommand("@CompanyId ", companyId);

                IDataReader dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spS_PaymentCategory");

                return this.GetPaymentCategoryData(dataReader);
            }
            catch
            {
                throw;
            }
            finally
            {
                this.databaseHelper.CloseConnection();
            }
        }

        public PaymentCategoryModel GetById(long medicineCategoryId)
        {
            try
            {
                this.databaseHelper = new DBHelper();

                this.databaseHelper.SetParameterToSQLCommand("@PaymentCategoryId", medicineCategoryId);
                IDataReader dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spS_PaymentCategoryById");

                List<PaymentCategoryModel> list = this.GetPaymentCategoryData(dataReader);

                if (list != null && list.Count > 0)
                {
                    return list[0];
                }
                else
                {
                    return null;
                }
            }
            catch
            {
                throw;
            }
            finally
            {
                this.databaseHelper.CloseConnection();
            }
        }
      
        public PaymentCategoryModel Save(PaymentCategoryModel medicineCategory)
        {
            this.databaseHelper = new DBHelper();

            this.databaseHelper.SetParameterToSQLCommand("@PaymentCategory", medicineCategory.PaymentCategory);
            this.databaseHelper.SetParameterToSQLCommand("@Description", medicineCategory.Description);
            this.databaseHelper.SetParameterToSQLCommand("@IsActive", medicineCategory.IsActive);
            this.databaseHelper.SetParameterToSQLCommand("@CreatedBy", medicineCategory.CreatedBy);
            this.databaseHelper.SetParameterToSQLCommand("@CompanyId", medicineCategory.CompanyId);

            IDataReader dataReader;
            PaymentCategoryModel tempUser = new PaymentCategoryModel();

            if (medicineCategory.PaymentCategoryId > 0)
            {
                this.databaseHelper.SetParameterToSQLCommand("@PaymentCategoryId", medicineCategory.PaymentCategoryId);
                dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spU_PaymentCategory");
            }
            else
            {
                dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spI_PaymentCategory");
            }

            if (dataReader != null)
            {
                using (dataReader)
                {
                    while (dataReader.Read())
                    {
                        tempUser.PaymentCategoryId = SqlHelper.GetDBLongValue(dataReader["RETURNVAL"]);
                        tempUser.DuplicateColumn = SqlHelper.GetDBStringValue(dataReader["DuplicateColumn"]);
                    }

                    return tempUser;
                }
            }
            else
            {
                return null;
            }
        }

        public int UpdateMultipleRecords(MultiOperationType operationType, string multiIds)
        {
            this.databaseHelper = new DBHelper();

            this.databaseHelper.SetParameterToSQLCommand("@MultiIds", multiIds);
            this.databaseHelper.SetParameterToSQLCommand("@OperationType", (int)operationType);

            return SqlHelper.ParseNativeInt(this.databaseHelper.GetExecuteScalarByStoredProcedure("HMS_spM_PaymentCategory").ToString());
        }

        #endregion

        #region Private Methods

        private List<PaymentCategoryModel> GetPaymentCategoryData(IDataReader dataReader)
        {
            if (dataReader != null)
            {
                using (dataReader)
                {
                    PaymentCategoryModel medicineCategory;
                    List<PaymentCategoryModel> medicineCategoryList = new List<PaymentCategoryModel>();

                    while (dataReader.Read())
                    {
                        medicineCategory = new PaymentCategoryModel();

                        medicineCategory.PaymentCategoryId = SqlHelper.GetDBLongValue(dataReader["PaymentCategoryId"]);
                        medicineCategory.PaymentCategory = SqlHelper.GetDBStringValue(dataReader["PaymentCategory"]);
                        medicineCategory.Description = SqlHelper.GetDBStringValue(dataReader["Description"]);
                        medicineCategory.IsActive = SqlHelper.GetDBBoolValue(dataReader["IsActive"]);

                        medicineCategoryList.Add(medicineCategory);
                    }

                    if (medicineCategoryList.Count > 0)
                    {
                        dataReader.NextResult();

                        while (dataReader.Read())
                        {
                            medicineCategoryList[0].TotalRecordCount = SqlHelper.GetDBIntValue(dataReader["TotalRecordCount"]);
                        }
                    }

                    return medicineCategoryList;
                }
            }
            else
            {
                return null;
            }
        }
        #endregion

        #endregion

        #region Dispose Methods

        /// <summary>
        /// Performs application-defined tasks associated with freeing, releasing, or resetting unmanaged resources.
        /// </summary>
        public void Dispose()
        {
            this.Dispose(true);
        }

        /// <summary>
        /// Releases unmanaged and - optionally - managed resources.
        /// </summary>
        /// <param name="disposing"><c>true</c> to release both managed and unmanaged resources; <c>false</c> to release only unmanaged resources.</param>
        protected virtual void Dispose(bool disposing)
        {
            if (disposing)
            {
                this.databaseHelper.Dispose();
            }
        }

        #endregion
    }
}