﻿
using System;
using System.Collections.Generic;
using System.Data;
using HMS.Class.Helper;
using HMS.Models;

namespace HMS.Class.DAL
{

    public class ReportDAL : IDisposable
    {
        #region Variable Declaration

        private DBHelper databaseHelper;

        #endregion

        #region LabTest

        #region Public Methods
        public List<ReportModel> GetAll( string searchField, string searchValue, string sortField, string sortOrder, int pageNo, int pageSize, int reportType)
        {
            try
            {
                this.databaseHelper = new DBHelper();

                this.databaseHelper.SetParameterToSQLCommand("@SearchField", searchField);
                this.databaseHelper.SetParameterToSQLCommand("@SearchValue", searchValue);
                this.databaseHelper.SetParameterToSQLCommand("@SortField", sortField);
                this.databaseHelper.SetParameterToSQLCommand("@SortOrder", sortOrder);
                this.databaseHelper.SetParameterToSQLCommand("@PageNo", pageNo);
                this.databaseHelper.SetParameterToSQLCommand("@PageSize", pageSize);

                this.databaseHelper.SetParameterToSQLCommand("@ReportTypeId", reportType);

                long companyId = SqlHelper.ParseNativeLong(CommonLogic.GetSessionValue(StringConstants.CompanyId));
                this.databaseHelper.SetParameterToSQLCommand("@CompanyId ", companyId);

                IDataReader dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spS_Report");

                return this.GetReportData(dataReader);
            }
            catch
            {
                throw;
            }
            finally
            {
                this.databaseHelper.CloseConnection();
            }
        }

        public ReportModel GetById(long reportId)
        {
            try
            {
                this.databaseHelper = new DBHelper();

                this.databaseHelper.SetParameterToSQLCommand("@ReportId", reportId);
                IDataReader dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spS_ReportById");

                List<ReportModel> list = this.GetReportData(dataReader);

                if (list != null && list.Count > 0)
                {
                    return list[0];
                }
                else
                {
                    return null;
                }
            }
            catch
            {
                throw;
            }
            finally
            {
                this.databaseHelper.CloseConnection();
            }
        }
      
        public ReportModel Save(ReportModel report)
        {
            this.databaseHelper = new DBHelper();

            this.databaseHelper.SetParameterToSQLCommand("@ReportTypeId", report.ReportTypeId);
            this.databaseHelper.SetParameterToSQLCommand("@Description", report.Description);
            this.databaseHelper.SetParameterToSQLCommand("@PatientId", report.PatientId);
            this.databaseHelper.SetParameterToSQLCommand("@ReportDate", report.ReportDate);
            this.databaseHelper.SetParameterToSQLCommand("@CreatedBy", report.CreatedBy);
            this.databaseHelper.SetParameterToSQLCommand("@CompanyId", report.CompanyId);

            if (!string.IsNullOrEmpty(report.ReportFile))
            {
                this.databaseHelper.SetParameterToSQLCommand("@ReportFile", report.ReportFile);
            }

            IDataReader dataReader;
            ReportModel tempUser = new ReportModel();

            if (report.ReportId > 0)
            {
                this.databaseHelper.SetParameterToSQLCommand("@ReportId", report.ReportId);
                dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spU_Report");
            }
            else
            {
                dataReader = this.databaseHelper.GetReaderByStoredProcedure("HMS_spI_Report");
            }

            if (dataReader != null)
            {
                using (dataReader)
                {
                    while (dataReader.Read())
                    {
                        tempUser.ReportId = SqlHelper.GetDBLongValue(dataReader["RETURNVAL"]);
                        tempUser.DuplicateColumn = SqlHelper.GetDBStringValue(dataReader["DuplicateColumn"]);
                    }

                    return tempUser;
                }
            }
            else
            {
                return null;
            }
        }

        public int UpdateMultipleRecords(MultiOperationType operationType, string multiIds)
        {
            this.databaseHelper = new DBHelper();

            this.databaseHelper.SetParameterToSQLCommand("@MultiIds", multiIds);
            this.databaseHelper.SetParameterToSQLCommand("@OperationType", (int)operationType);

            return SqlHelper.ParseNativeInt(this.databaseHelper.GetExecuteScalarByStoredProcedure("HMS_spM_Report").ToString());
        }

        #endregion

        #region Private Methods

        private List<ReportModel> GetReportData(IDataReader dataReader)
        {
            if (dataReader != null)
            {
                using (dataReader)
                {
                    ReportModel report;
                    List<ReportModel> reportList = new List<ReportModel>();

                    while (dataReader.Read())
                    {
                        report = new ReportModel();

                        report.ReportId = SqlHelper.GetDBLongValue(dataReader["ReportId"]);
                        report.Description = SqlHelper.GetDBStringValue(dataReader["Description"]);
                        report.PatientId = SqlHelper.GetDBLongValue(dataReader["PatientId"]);
                        report.ReportDate = SqlHelper.GetDBDateTimeValue(dataReader["ReportDate"]);
                        report.ReportTypeId = SqlHelper.GetDBLongValue(dataReader["ReportTypeId"]);
                        report.PatientName = SqlHelper.GetDBStringValue(dataReader["PatientName"]);
                        report.ReportFile = SqlHelper.GetDBStringValue(dataReader["ReportFile"]);
                        report.CompanyId = SqlHelper.GetDBLongValue(dataReader["CompanyId"]);

                        reportList.Add(report);
                    }

                    if (reportList.Count > 0)
                    {
                        dataReader.NextResult();

                        while (dataReader.Read())
                        {
                            reportList[0].TotalRecordCount = SqlHelper.GetDBIntValue(dataReader["TotalRecordCount"]);
                        }
                    }

                    return reportList;
                }
            }
            else
            {
                return null;
            }
        }
        #endregion

        #endregion

        #region Dispose Methods

        /// <summary>
        /// Performs application-defined tasks associated with freeing, releasing, or resetting unmanaged resources.
        /// </summary>
        public void Dispose()
        {
            this.Dispose(true);
        }

        /// <summary>
        /// Releases unmanaged and - optionally - managed resources.
        /// </summary>
        /// <param name="disposing"><c>true</c> to release both managed and unmanaged resources; <c>false</c> to release only unmanaged resources.</param>
        protected virtual void Dispose(bool disposing)
        {
            if (disposing)
            {
                this.databaseHelper.Dispose();
            }
        }

        #endregion
    }
}
