﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web;

namespace HMS.Class.Helper
{
    public class AppLogic
    {

        public static string GetProfilePicture()
        {
            
            string defPath = CommonLogic.GetConfigValue(StringConstants.AppConfig_DefaultProfilePic);
            string picFolder = AppLogic.GetProfilePicFolder();
            string profilePic = CommonLogic.GetSessionValue(StringConstants.ProfilePic);
            string path = Path.Combine(CommonLogic.GetConfigValue(StringConstants.AppConfig_ProfilePicFolderPath), picFolder, CommonLogic.GetSessionValue(StringConstants.CompanyId));

            if (!string.IsNullOrEmpty(profilePic))
            {
                string physicalPath = Path.Combine(HttpContext.Current.Server.MapPath(path), profilePic);
                if (System.IO.File.Exists(physicalPath))
                {
                    return Path.Combine(path, profilePic);
                }
            }
            return defPath;
        }


        public static string GetProfilePicFolder()
        {
            RoleType role = (RoleType)Enum.Parse(typeof(RoleType), CommonLogic.GetSessionValue(StringConstants.RoleId));

            switch (role)
            {

                case RoleType.SuperAdmin:
                    return "SuperAdmin";
                case RoleType.Admin:
                    return "Admin";
                case RoleType.Doctor:
                    return "Doctor";
                case RoleType.Nurse:
                    return "Nurse";
                case RoleType.Laboratorist:
                    return "Lab";
                case RoleType.Pharmacist:
                    return "Pharma";
                case RoleType.Accountant:
                    return "Accountant";
                default:
                    return string.Empty;
            }
        }
    }
}