﻿using System.Web.Mvc;
using HMS.Class.BLL;
using HMS.Class.Helper;
using HMS.Models;
using HMS.ViewModel;

namespace HMS.Controllers
{
    /// <summary>
    /// Dashboard controller class.
    /// </summary>
    [LogOnAuthorize]
    public class DashboardController : BaseController
    {
        #region Action Methods

        /// <summary>
        /// Index view action.
        /// </summary>
        /// <returns>
        /// Returns index action result.
        /// </returns>
        public ActionResult Index()
        {

            DashboardViewModel dashboardModel = SettingBLL.GetDashboardDetails();
            if (dashboardModel == null)
            {
                dashboardModel = new DashboardViewModel();
                dashboardModel.RoleId = 0;
            }
            return Request.IsAjaxRequest() ? (ActionResult)PartialView("Index", dashboardModel) : this.View(dashboardModel);
        }

        #endregion
    }
}
