﻿using System;
using System.Collections.Generic;
using System.Web.Mvc;
using HMS.Class.BLL;
using HMS.Class.Helper;
using HMS.Models;
using HMS.ViewModel;

namespace HMS.Controllers
{
      [LogOnAuthorize(Roles = "2,3,6")]
    public class PatientTestController : BaseController
    {
        #region Action Methods

        /// <summary>
        /// Index view action.
        /// </summary>
        /// <param name="page">The page.</param>
        /// <param name="pageSize">Size of the page.</param>
        /// <param name="searchField">The search field.</param>
        /// <param name="searchValue">The search value.</param>
        /// <param name="sortField">The sort field.</param>
        /// <param name="sortOrder">The sort order.</param>
        /// <returns>
        /// Returns index action result.
        /// </returns>
        public ActionResult Index(int? page, int? pageSize, string searchField, string searchValue, string sortField, string sortOrder)
        {
            if (CommonLogic.GetQueryString("status").Equals("s", StringComparison.CurrentCultureIgnoreCase))
            {
                ViewBag.SuccessMsg = string.Format(StringConstants.RecordSave, "PatientTest");
            }

            ViewBag.PageNo = page ?? 1;
            ViewBag.PageSize = pageSize ?? MvcApplication.Setting.PageSize;
            ViewBag.SearchField = (string.IsNullOrEmpty(searchField) && !string.IsNullOrEmpty(searchValue)) ? "PatientName" : searchField;
            ViewBag.SearchValue = searchValue;
            ViewBag.SortField = !string.IsNullOrEmpty(sortField) ? sortField : "TestDate";
            ViewBag.SortOrder = !string.IsNullOrEmpty(sortOrder) ? sortOrder : "DESC";

            string mode = CommonLogic.GetFormDataString("mode");
            string ids = CommonLogic.GetFormDataString("ids");

            if (!string.IsNullOrEmpty(mode) && !string.IsNullOrEmpty(ids))
            {
                try
                {
                    MultiOperationType operationType = (MultiOperationType)Enum.Parse(typeof(MultiOperationType), mode, true);
                    PatientTestBLL.UpdateMultipleRecords(operationType, ids);
                }
                catch (Exception ex)
                {
                    return this.Json(new { IsError = true, ErrorMsg = CommonLogic.GetExceptionMessage(ex) });
                }
            }

      
            List<PatientTestModel> patientTestList = PatientTestBLL.GetAll(ViewBag.SearchField, ViewBag.SearchValue, ViewBag.SortField, ViewBag.SortOrder, ViewBag.PageNo, ViewBag.PageSize);
            int totalRecords = 0;

            if (patientTestList != null && patientTestList.Count > 0)
            {
                totalRecords = patientTestList[0].TotalRecordCount;
            }

            ViewBag.ListRecords = patientTestList.Count;
            ViewBag.PagedList = patientTestList.ToStaticPagedList((int)ViewBag.PageNo, (int)ViewBag.PageSize, totalRecords);

            return Request.IsAjaxRequest() ? (ActionResult)PartialView("Index", patientTestList) : this.View(patientTestList);
        }

        /// <summary>
        /// Add view action.
        /// </summary>
        /// <param name="id">The identifier.</param>
        /// <returns>
        /// Returns add action result.
        /// </returns>
        public ActionResult Add(long? id)
        {
            var patientTestVM = new PatientTestViewModel(id);
            ViewBag.Heading = "Add PatientTest";

            ViewBag.LabTests = new SelectList(LabTestBLL.GetAllActive(), "LabTestId", "LabTestName");

            if (id.HasValue && id > 0)
            {
                ViewBag.Heading = "Edit PatientTest";
                patientTestVM.PatientTest = PatientTestBLL.GetById(id ?? 0);

                if (patientTestVM.PatientTest == null)
                {
                    patientTestVM.PatientTest = new PatientTestModel();
                }
            }

            return Request.IsAjaxRequest() ? (ActionResult)PartialView("Add", patientTestVM) : this.View(patientTestVM);
        }

        /// <summary>
        /// Add view post action.
        /// </summary>
        /// <param name="id">The identifier.</param>
        /// <param name="patientTestVM">The model.</param>
        /// <returns>
        /// Returns add action result.
        /// </returns>
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Add(long? id, PatientTestViewModel patientTestVM, List<PatientTestDetailModel> patientTestDetailList)
        {
            try
            {
                ViewBag.Heading = "Add PatientTest";

                patientTestVM.PatientTestDetails = patientTestDetailList;

                ViewBag.LabTests = new SelectList(LabTestBLL.GetAllActive(), "LabTestId", "LabTestName");

                if (patientTestVM.PatientTest.PatientTestId > 0)
                {
                    ViewBag.Heading = "Edit PatientTest";
                }

                if (ModelState.IsValid)
                {
                    patientTestVM.PatientTest.CompanyId = SqlHelper.ParseNativeLong(CommonLogic.GetSessionValue(StringConstants.CompanyId));
                    patientTestVM.PatientTest.CreatedBy = SqlHelper.ParseNativeLong(CommonLogic.GetSessionValue(StringConstants.UserId));
                    //model.RoleId = RoleType.Patient.GetHashCode();

                   long patientTestId = PatientTestBLL.Save(patientTestVM);
                }
            }
            catch (System.Exception ex)
            {
                ViewBag.ErrorMsg = CommonLogic.GetExceptionMessage(ex);
            }

            return Request.IsAjaxRequest() ? (ActionResult)PartialView("Add", patientTestVM) : this.View(patientTestVM);
        }

        public PartialViewResult BlankEditorRow()
        {

            ViewBag.LabTests = new SelectList(LabTestBLL.GetAllActive(), "LabTestId", "LabTestName");
            return PartialView("LabTestRow", new PatientTestDetailModel());
        }
        #endregion
    }
}
