﻿using System;
using System.Collections.Generic;
using System.Web.Mvc;
using HMS.Class.BLL;
using HMS.Class.Helper;
using HMS.Models;
using HMS.ViewModel;

namespace HMS.Controllers
{
    [LogOnAuthorize(Roles = "2,6")]
    public class PublicBloodBankController : BaseController
    {
        #region Action Methods

        /// <summary>
        /// Add view action.
        /// </summary>
        /// <param name="id">The identifier.</param>
        /// <returns>
        /// Returns add action result.
        /// </returns>
        public ActionResult Index(string bloodGroup)
        {
            var vm = new BloodBankViewModel();

            vm.Hospitals = BloodInventoryBLL.GetHospitals(bloodGroup);
            vm.BloodGroup = bloodGroup;
            return Request.IsAjaxRequest() ? (ActionResult)PartialView("Index", vm) : this.View(vm);
        }

        #endregion
    }
}
