﻿using System.Web.Mvc;
using HMS.Class.BLL;
using HMS.Class.Helper;
using HMS.Models;

namespace HMS.Controllers
{
    /// <summary>
    /// Site Feature controller class.
    /// </summary>
  [LogOnAuthorize(Roles = "1")]
    public class SiteFeaturesController : BaseController
    {
        /// <summary>
        /// Index view action.
        /// </summary>
        /// <returns>
        /// Returns index action result.
        /// </returns>
        public ActionResult Index()
        {
            SettingModel settingModel = SettingBLL.GetSetting();

            if (settingModel == null)
            {
                settingModel = new SettingModel();
            }

            return Request.IsAjaxRequest() ? (ActionResult)PartialView("Index", settingModel) : this.View(settingModel);
        }

        /// <summary>
        /// Index view post action.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns>
        /// Returns index action result.
        /// </returns>
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Index(SettingModel model)
        {
            try
            {
                if (ModelState.IsValid)
                {
                    long settingId = SettingBLL.SaveSetting(model);

                    if (settingId > 0)
                    {
                        MvcApplication.SetGlobalVariable();
                        ViewBag.SuccessMsg = string.Format(StringConstants.RecordSave, "Site Features");
                    }
                    else
                    {
                        ViewBag.ErrorMsg = string.Format(StringConstants.RecordSaveError, "Site Features");
                    }
                }
            }
            catch (System.Exception ex)
            {
                ViewBag.ErrorMsg = CommonLogic.GetExceptionMessage(ex);
            }

            return Request.IsAjaxRequest() ? (ActionResult)PartialView("Index", model) : this.View(model);
        }
    }
}
