﻿using HMS.Class.BLL;
using HMS.Class.Helper;
using HMS.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Optimization;
using System.Web.Routing;

namespace HMS
{
    public class MvcApplication : System.Web.HttpApplication
    {
        #region Variable Declaration

        private static SettingModel setting;

        #endregion

        #region Properties

        /// <summary>
        /// Gets or sets the setting.
        /// </summary>
        /// <value>
        /// The setting.
        /// </value>
        public static SettingModel Setting
        {
            get
            {
                if (setting == null)
                {
                    SetGlobalVariable();
                }

                return setting;
            }

            set
            {
                setting = value;
            }
        }

        #endregion

        #region Public Methods

        /// <summary>
        /// Sets the global variable.
        /// </summary>
        public static void SetGlobalVariable()
        {
            setting = SettingBLL.GetSetting();

            if (setting != null)
            {
                CommonLogic.SetApplicationValue("SMTPHost", setting.SMTPHost);
                CommonLogic.SetApplicationValue("SMTPPort", setting.SMTPPort);
                CommonLogic.SetApplicationValue("SMTPUserName", setting.SMTPUserName);
                CommonLogic.SetApplicationValue("SMTPPassword", setting.SMTPPassword);
            }
            else
            {
                setting = new SettingModel();
            }
        }

        #endregion
        protected void Application_Start()
        {
            ViewEngines.Engines.Clear();
            ViewEngines.Engines.Add(new RazorViewEngine());

            AreaRegistration.RegisterAllAreas();
            FilterConfig.RegisterGlobalFilters(GlobalFilters.Filters);
            RouteConfig.RegisterRoutes(RouteTable.Routes);
            BundleConfig.RegisterBundles(BundleTable.Bundles);
        }
    }
}
