﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web;

namespace HMS.Models
{
    public class BedCategoryModel
    {
        public BedCategoryModel()
        {
            this.IsActive = true;
        }
        public long BedCategoryId { get; set; }

        [Required]
        [Display(Name = "Bed Category")]
        public string BedCategory { get; set; }

        [Display(Name = "Description")]
        public string Description { get; set; }

        [Display(Name = "Status")]
        public bool IsActive { get; set; }

        public long CompanyId { get; set; }

        public long CreatedBy { get; set; }
        public int TotalRecordCount { get; set; }

        public string DuplicateColumn { get; set; }

    }
    public class BedModel
    {
         public BedModel()
        {
            this.IsActive = true;
        }
        public long BedId { get; set; }

        public long CompanyId { get; set; }

        [Required]
        [Display(Name = "Bed No.")]
        public string BedName { get; set; }
        
        [Required]
        [Display(Name="Bed Category")]
        public long BedCategoryId { get; set; }

        public string BedCategory { get; set; }

        public string Description { get; set; }

        public bool IsAvailable { get; set; }

        [Display(Name = "Status")]
        public bool IsActive { get; set; }

        public long CreatedBy { get; set; }
        public int TotalRecordCount { get; set; }

        public string DuplicateColumn { get; set; }
    }

    public class BedAllotmentModel
    {
        public long BedAllotmentId { get; set; }
        public long CompanyId { get; set; }

        [Display(Name = "Patient")]
        [Required]
        public long PatientId { get; set; }
        public string PatientName {get; set;}

        [Required]
        [Display(Name="Bed No.")]
        public long BedId { get; set; }
        public string BedName { get; set; }

        [Display(Name = "Bed Category")]
        public long BedCategoryId { get; set; }
        public string BedCategory { get; set; }

        [Required]
        [Display(Name="Allotment Date")]
        public DateTime? AllotmentDate { get; set; }

        [Display(Name = "Discharge Date")]
        public DateTime? DischargeDate { get; set; }
        public string Notes { get; set; }

        public long CreatedBy { get; set; }
        public int TotalRecordCount { get; set; }

        public string DuplicateColumn { get; set; }
    }
}