﻿using HMS.Class.Helper;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web;

namespace HMS.Models
{
    public class CompanyModel
    {
        public CompanyModel()
        {
            this.IsActive = true;
        }

        public long CompanyId { get; set; }

        [Required]
        [Display(Name="Hospital Name")]
        public string CompanyName { get; set; }

        [Required]
        public string Address1 { get; set; }
        public string Address2 { get; set; }

        [Required]
        public string City { get; set; }
        [Required]
        public string State { get; set; }
        [Required]
        public string ZipCode { get; set; }
        [Required]
        public string Phone { get; set; }
        public string Fax { get; set; }

        [Required]
        [RegularExpression(StringConstants.EmailRegEx, ErrorMessage = "Enter valid email.")]
        [DataType(DataType.EmailAddress)]
        public string Email { get; set; }
        [Required]

        [Display(Name = "Status")]
        public bool IsActive { get; set; }

        public long CreatedBy { get; set; }

        public int TotalRecordCount { get; set; }

        public string DuplicateColumn { get; set; }
    }
}