﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web;

namespace HMS.Models
{
    public class ExpenseCategoryModel
    {
        public ExpenseCategoryModel()
        {
            this.IsActive = true;
        }
        public long ExpenseCategoryId { get; set; }

        [Required]
        [Display(Name = "Expense Category")]
        public string ExpenseCategory { get; set; }

        [Display(Name = "Description")]
        public string Description { get; set; }

        [Display(Name = "Status")]
        public bool IsActive { get; set; }

        public long CompanyId { get; set; }

        public long CreatedBy { get; set; }
        public int TotalRecordCount { get; set; }

        public string DuplicateColumn { get; set; }

    }
    public class ExpenseModel
    {
        public long ExpenseId { get; set; }

        public long CompanyId { get; set; }

        [Required]
        [Display(Name="Expense Category")]
        public long ExpenseCategoryId { get; set; }

        public string ExpenseCategory { get; set; }

        public DateTime ExpenseDate { get; set; }

        [Required]
        [Display(Name="Amount")]
        [DataType(DataType.Currency)]
        public decimal ExpenseAmount{ get; set; }
        
        public long CreatedBy { get; set; }
        public int TotalRecordCount { get; set; }

        public string DuplicateColumn { get; set; }
    }
}