﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web;

namespace HMS.Models
{
    public class LabTestCategoryModel
    {
        public LabTestCategoryModel()
        {
            this.IsActive = true;
        }
        public long LabTestCategoryId { get; set; }

        [Required]
        [Display(Name = "LabTest Category")]
        public string LabTestCategoryName { get; set; }

        [Display(Name = "Description")]
        public string Description { get; set; }

        [Display(Name = "Status")]
        public bool IsActive { get; set; }

        public long CompanyId { get; set; }

        public long CreatedBy { get; set; }
        public int TotalRecordCount { get; set; }

        public string DuplicateColumn { get; set; }

    }
    public class LabTestModel
    {
        public LabTestModel()
        {
            this.IsActive = true;
        }
        public long LabTestId { get; set; }

        public long CompanyId { get; set; }

        [Required]
        [Display(Name="LabTest Category")]
        public long LabTestCategoryId { get; set; }

        [Required]
        [Display(Name="LabTest Name")]
        public string LabTestName { get; set; }

        public string LabTestCategoryName { get; set; }

        //[Required]
        //[Display(Name="Amount")]
        //[DataType(DataType.Currency)]
        //public decimal LabTestPrice{ get; set; }

        [Required]
        [Display(Name = "Unit")]
        public string TestUnit { get; set; }

        [Required]
        [Display(Name = "Reference Range")]
        public string ReferenceRange { get; set; }

        [Display(Name = "Status")]
        public bool IsActive { get; set; }
        
        public long CreatedBy { get; set; }
        public int TotalRecordCount { get; set; }

        public string DuplicateColumn { get; set; }
    }
}