﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web;

namespace HMS.Models
{
    public class MedicineCategoryModel
    {
        public MedicineCategoryModel()
        {
            this.IsActive = true;
        }
        public long MedicineCategoryId { get; set; }

        [Required]
        [Display(Name="Medicine Category")]
        public string  MedicineCategory { get; set; }

        [Display(Name = "Status")]
        public bool IsActive { get; set; }

        public long CompanyId { get; set; }

        public long CreatedBy { get; set; }
        public int TotalRecordCount { get; set; }

        public string DuplicateColumn { get; set; }

    }
    public class MedicineModel
    {
        public MedicineModel()
        {
            this.IsActive = true;
        }

        public long MedicineId { get; set; }

        public long CompanyId { get; set; }

        [Required]
        [Display(Name="Medicine Name")]
        public string MedicineName { get; set; }

        public string Description { get; set; }

        [Display(Name = "Medicine Category")]
        public long MedicineCategoryId { get; set; }
        public string MedicineCategory { get; set; }
        public int AvailableQuantity { get; set; }
        public long UnitId { get; set; }

        [Display(Name = "Status")]
        public bool IsActive { get; set; }
        public long CreatedBy { get; set; }
        public int TotalRecordCount { get; set; }

        public string DuplicateColumn { get; set; }
    }
}