﻿using System.ComponentModel.DataAnnotations;
using HMS.Class.Helper;
using System;
using System.Collections.Generic;

namespace HMS.Models
{

    #region Patient Model
    /// <summary>
    /// Patient model class.
    /// </summary>
    public class PatientModel
    {

        public PatientModel()
        {
            this.IsActive = true;
        }

        #region Properties

        /// <summary>
        /// Gets or sets the user id.
        /// </summary>
        /// <value>
        /// The user id.
        /// </value>
        public long UserId { get; set; }

        /// <summary>
        /// Gets or sets the first name.
        /// </summary>
        /// <value>
        /// The first name.
        /// </value>
        [Required]
        [Display(Name = "First Name")]
        public string FirstName { get; set; }

        /// <summary>
        /// Gets or sets the name of the middle.
        /// </summary>
        /// <value>
        /// The name of the middle.
        /// </value>
        [Required]
        [Display(Name = "Middle Name")]
        public string MiddleName { get; set; }

        /// <summary>
        /// Gets or sets the last name.
        /// </summary>
        /// <value>
        /// The last name.
        /// </value>
        [Required]
        [Display(Name = "Last Name")]
        public string LastName { get; set; }

        /// <summary>
        /// Gets the full name.
        /// </summary>
        /// <value>
        /// The full name.
        /// </value>
        public string FullName
        {
            get
            {
                return string.Concat(this.FirstName, ' ', this.LastName);
            }
        }

        /////// <summary>
        /////// Gets or sets the name of the user.
        /////// </summary>
        /////// <value>
        /////// The name of the user.
        /////// </value>
        ////[Required]
        ////[Display(Name = "User Name")]
        ////public string UserName { get; set; }

        /// <summary>
        /// Gets or sets the email.
        /// </summary>
        /// <value>
        /// The email.
        /// </value>
        [Required]
        [RegularExpression(StringConstants.EmailRegEx, ErrorMessage = "Enter valid email.")]
        [Display(Name = "Email (User Name)")]
        public string Email { get; set; }

        /// <summary>
        /// Gets or sets the password.
        /// </summary>
        /// <value>
        /// The password.
        /// </value>
        [Required]
        [DataType(DataType.Password)]
        [Display(Name = "Password")]
        public string Password { get; set; }

        /// <summary>
        /// Gets or sets the phone.
        /// </summary>
        /// <value>
        /// The phone.
        /// </value>
        [Required]
        [Display(Name = "Phone")]
        public string Phone { get; set; }

        /// <summary>
        /// Gets or sets the role id.
        /// </summary>
        /// <value>
        /// The role id.
        /// </value>

        [Display(Name = "Role")]
        public long? RoleId { get; set; }

        /// <summary>
        /// Gets or sets the name of the role.
        /// </summary>
        /// <value>
        /// The name of the role.
        /// </value>
        public string RoleName { get; set; }

        /// <summary>
        /// Create By.
        /// </summary>
        /// <value>
        ///   Created By
        /// </value>
        public long CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets role Id.
        /// </summary>
        /// <value>
        /// the name of the company
        /// </value>

        [Display(Name = "Hospital")]
        public long? CompanyId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is active; otherwise, <c>false</c>.
        /// </value>

        [Display(Name = "Status")]
        public bool IsActive { get; set; }

        /// <summary>
        /// Gets or sets the total record count.
        /// </summary>
        /// <value>
        /// The total record count.
        /// </value>
        public int TotalRecordCount { get; set; }

        /// <summary>
        /// Gets or sets the duplicate column.
        /// </summary>
        /// <value>
        /// The duplicate column.
        /// </value>
        public string DuplicateColumn { get; set; }

        [DataType(DataType.Date)]
        [Display(Name = "Birth Date")]
        [DisplayFormat(DataFormatString = "{0:dd-MMM-yyyy}", ApplyFormatInEditMode = true)]
        public DateTime? BirthDate { get; set; }
        public string Gender { get; set; }

        [Display(Name = "Blood Group")]
        public string BloodGroup { get; set; }

        [Display(Name="Address")]
        public string Address1 { get; set; }

        [Display(Name = "Profile Picture")]
        public string ProfilePic { get; set; }

        [Display(Name = "Patient Id")]
        public string PatientCode { get; set; }

        [Display(Name = "Registrant Hospital")]
        public string CompanyName { get; set; }


        #endregion
    }

    #endregion

    #region Patient Checkup Model

    public class PatientCheckupModel
    {
        public PatientCheckupModel()
        {
            this.Prescription = new PrescriptionModel();
        }
        public long PatientCheckupId { get; set; }
        public long PatientId { get; set; }

        [Display(Name = "Checkup Date")]
        [DisplayFormat(DataFormatString = "{0:dd-MMM-yyyy}", ApplyFormatInEditMode = true)]
        public DateTime? CheckupDate { get; set; }

        [Required]
        [Display(Name = "Doctor")]
        public long DoctorId { get; set; }
        public string DoctorName { get; set; }

        [Required]
        public string Symptoms { get; set; }

        [Required]
        public string Diagnosis { get; set; }
        public PrescriptionModel Prescription { get; set; }


    }

    #endregion


    #region Prescription

    public class PrescriptionModel
    {
        public long PrescriptionId { get; set; }
        public long PatientCheckupId { get; set; }
        public long PatientId { get; set; }
        public long TreatmentId { get; set; }
        public string CaseHistory { get; set; }
        public string ExtraNotes { get; set; }
        public DateTime PrescriptionDate { get; set; }

        [Display(Name = "Medication")]
        public List<PrescriptionDetailModel> MedicineList { get; set; }
    }

    public class PrescriptionDetailModel
    {
        public long PrescriptionDetailId { get; set; }
        public long PrescriptionId { get; set; }
        public long PatientId { get; set; }

        [Required]
        public long MedicineId { get; set; }

        public string MedicineName { get; set; }
        [Required]
        public int NoOfDays { get; set; }

        [Required]
        public string WhenToTake { get; set; }
        public bool IsBeforeMeal { get; set; }

    }



    #endregion


    #region Treatment

    public class TreatmentModel
    {
        public long TreatmentId { get; set; }
        public string TreatmentName { get; set; }
    }

    #endregion

   

  
   


}