﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web;

namespace HMS.Models
{
   
    public class PatientTestModel
    {
        public long PatientTestId { get; set; }

        public long CompanyId { get; set; }

        [Required]
        [Display(Name = "Patient")]
        public long PatientId { get; set; }

        [Required]
        [Display(Name = "Consultant")]
        public long ConsultantId { get; set; }

        public string PatientName { get; set; }

        [DisplayFormat(DataFormatString = "{0:dd/MMM/yyyy}")]
        public DateTime? TestDate { get; set; }

        [DisplayFormat(DataFormatString = "{0:dd/MMM/yyyy}")]
        public DateTime? DeliveryDate { get; set; }



        
        [Display(Name = "Payment Status")]
        public int ReportStatus { get; set; }

        public string ReportStatusText
        {
            get 
            {
                if (this.ReportStatus == 0)
                    return "Pending";
                else if (this.ReportStatus == 1)
                    return "Delivered";

                return "Pending";
            }
        }
        public long CreatedBy { get; set; }
        public int TotalRecordCount { get; set; }

        public string DuplicateColumn { get; set; }
    }

    public class PatientTestDetailModel
    {
        public long PatientTestId { get; set; }
        public long LabTestId { get; set; }
        public string LabTestName { get; set; }
        public string Result { get; set; }
        public string Remarks { get; set; }
    }
}