﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web;

namespace HMS.Models
{
    public class PaymentCategoryModel
    {
        public PaymentCategoryModel()
        {
            this.IsActive = true;
        }
        public long PaymentCategoryId { get; set; }

        [Required]
        [Display(Name = "Payment Category")]
        public string PaymentCategory { get; set; }

        [Display(Name = "Description")]
        public string Description { get; set; }

        [Display(Name = "Status")]
        public bool IsActive { get; set; }
        public long CompanyId { get; set; }

        public long CreatedBy { get; set; }
        public int TotalRecordCount { get; set; }
        public string DuplicateColumn { get; set; }

    }
    public class PaymentModel
    {
        public long PaymentId { get; set; }

        public long CompanyId { get; set; }

        [Display(Name="Invoice #")]
        public string InvoiceNumber { get; set; }

        [Required]
        [Display(Name = "Patient")]
        public long PatientId { get; set; }

        public string PatientName { get; set; }

        [DisplayFormat(DataFormatString = "{0:dd/MMM/yyyy}")]
        public DateTime PaymentDate { get; set; }

        [Display(Name = "Sub Total")]
        public decimal SubTotal { get; set; }

      
        [DataType(DataType.Currency, ErrorMessage = "Please enter Valid Amount")]
        public decimal Discount { get; set; }

        [DataType(DataType.Currency, ErrorMessage = "Please enter Valid Amount")]
        public decimal Tax { get; set; }

        [Display(Name="Grand Total")]
        public decimal GrandTotal { get; set; }

        [Display(Name = "Payment Status")]
        public int PaymentStatus { get; set; }

        public string PaymentStatusText
        {
            get 
            {
                if (this.PaymentStatus == 0)
                    return "Unpaid";
                else if (this.PaymentStatus == 1)
                    return "Paid";

                return "Unpaid";
            }
        }
        public long CreatedBy { get; set; }
        public int TotalRecordCount { get; set; }

        public string DuplicateColumn { get; set; }
    }

    public class PaymentDetailModel
    {
        public long PaymentId { get; set; }
        public long PaymentCategoryId { get; set; }
        public string PaymentCategory { get; set; }

        [DataType(DataType.Currency, ErrorMessage = "Please enter Valid Amount")]
        public decimal PaymentAmount { get; set; }
    }
}