function checkAll() {
    if ($('#chkAll').is(":checked")) {
        $('[name="chkBox"]').attr('checked', true);
        $('[name="chkBox"]').parent().attr('class', 'checked');
    }
    else {
        $('[name="chkBox"]').attr('checked', false);
        $('[name="chkBox"]').parent().attr('class', '');
    }
}

function checkManual() {
    var chkBoxAll = $('#chkAll');
    if ($('[name="chkBox"]').length == $('[name="chkBox"]:checked').length) {
        $(chkBoxAll).attr('checked', true);
        $(chkBoxAll).parent().attr('class', 'checked');
    }
    else {
        $(chkBoxAll).attr('checked', false);
        $(chkBoxAll).parent().attr('class', '');
    }
}

function IsCheckBoxChecked() {
    return $('[name="chkBox"]:checked').length > 0;
}

function SetActiveInactive(obj, id) {
    UnCheck();
    var chkBox = $(obj).closest('tr').find('[name="chkBox"]')
    $(chkBox).prop('checked', true);
    $(chkBox).parent().attr('class', 'checked');
}

function UnCheck() {
    $('[name="chkBox"]').prop('checked', false);
    $('[name="chkBox"]').parent().attr('class', '');
}

function SearchOption() {
    var ddlSearchFieldValue = $('#ddlFilter').val();
    var includeDatePicker = false;

    if (ddlSearchFieldValue == "IsActive" || ddlSearchFieldValue == "Status") {
        $('#txtSearchField').hide();
        $('#ddlStatus').show();
    }
    else if (ddlSearchFieldValue.toLowerCase().indexOf('date') > -1) {
        $('#txtSearchField').show();
        includeDatePicker = true;
    }
    else {
        $('#txtSearchField').show();
        $('#ddlStatus').hide();
        $('#txtSearchField').val('');
    }
    InitDatePicker('txtSearchField', includeDatePicker);
    return false;
}


function Trim(s) {

    while ((s.substring(0, 1) == ' ') || (s.substring(0, 1) == '\n') || (s.substring(0, 1) == '\r')) {
        s = s.substring(1, s.length);
    }

    while ((s.substring(s.length - 1, s.length) == ' ') || (s.substring(s.length - 1, s.length) == '\n') || (s.substring(s.length - 1, s.length) == '\r')) {
        s = s.substring(0, s.length - 1);
    }

    return s;
}

function KeyPhone(e)    //This is for Phone No. textbox. Numeric with ( ) and - 
{
    var KeyID = (window.event) ? event.keyCode : e.which;
    if ((KeyID >= 65 && KeyID <= 90) || (KeyID >= 97 && KeyID <= 122) || (KeyID >= 33 && KeyID <= 39) || KeyID == 42 || KeyID == 44 || KeyID == 46 || KeyID == 47 ||
   (KeyID >= 58 && KeyID <= 64) || (KeyID >= 91 && KeyID <= 96) || (KeyID >= 123 && KeyID <= 126)) {
        return false;
    }
    if (KeyID == 32) {
        return false;
    }
}


function GetOriginalID(PassedID) {
    var LoopCounter;
    if (document.aspnetForm) {
        var FormElements = document.aspnetForm.elements;
        for (LoopCounter = 0; LoopCounter < FormElements.length; LoopCounter++) {
            if (FormElements[LoopCounter].id.indexOf(PassedID) >= 0)
                return FormElements[LoopCounter].id;
        }
    }
    return 'NotFound';
}

function SetFocus(PassedID) {
    if (document.getElementById(GetOriginalID(PassedID)))
        document.getElementById(GetOriginalID(PassedID)).focus();
}

function CheckImage(str) {
    var filter = /^.+(.jpeg|.JPEG|.jpg|.JPG|.jpe|.JPE|.png|.PNG|.gif|.GIF|.bmp|.BMP)$/i;

    if (filter.test(str))
        return true;
    else
        return false;
}

function CheckVideo(str) {
    var filter = /^.+(.wmv|.WMV|.flv|.FLV|.mpeg|.MPEG|.mpg|.MPG)$/i;

    if (filter.test(str))
        return true;
    else
        return false;
}

function CheckLibraryitem(str) {

    var filter = /^.+(.doc|.docx|.odt|.xls|.xlsx|.ods|.exls|.jpg|.jpeg|.gif|.png|.img|.pspimage|.psd|.bmp|.thm|.tif|.uuv|.pdf|.ppt|.pp|.pptx|.DOC|.DOCX|.ODT|.XLS|.XLSX|.ODS|.EXLS|.JPG|.JPEG|.GIF|.PNG|.IMG|.PSPIMAGE|.PSD|.BMP|.THM|.TIF|.UUV|.PDF|.PPT|.PP|.PPTX)$/i;

    if (filter.test(str))
        return true;
    else
        return false;
}

function CheckCSS(str) {
    var filter = /^.+(.css|.CSS)$/i;

    if (filter.test(str))
        return true;
    else
        return false;
}

function CheckPDF(str) {

    var filter = /^.+(.pdf|.PDF)$/i;

    if (filter.test(str))
        return true;
    else
        return false;
}

function KeyNumeric(e)    //This is for PostCode textbox. Only Numeric value
{
    var KeyID = (window.event) ? event.keyCode : e.which;

    if ((KeyID >= 65 && KeyID <= 90) || (KeyID >= 97 && KeyID <= 122) || (KeyID >= 33 && KeyID <= 47 && KeyID != 46) ||
        (KeyID >= 58 && KeyID <= 64) || (KeyID >= 91 && KeyID <= 96) || (KeyID >= 123 && KeyID <= 126)) {
        return false;
    }

    if (KeyID == 32) {
        return false;
    }
}

function ResetForm(validationGroup) {
    theForm.reset();
    return false;
}

function resetEditors() {
    // If the editor API does not exist, there are no editors
    if (typeof FCKeditorAPI == "undefined") return;

    // Loop through all FCK instances, in case there are several editors
    for (var sEditorName in FCKeditorAPI.__Instances) {
        // The initial value that was set when the form was created
        // is stored in a hidden <INPUT> with the same name as the
        // editor (the editor itself is in an <IFRAME> with ___Frame
        // appended to the name.  Check whether that INPUT exists
        if (document.getElementById(sEditorName)) {
            // Get the initial value
            var sInitialValue = document.getElementById(sEditorName).value;
            // Overwrite the editor's current value
            FCKeditorAPI.__Instances[sEditorName].SetHTML(sInitialValue);
        }
    }
}

// Adaptation from - JavaScript/jQuery HTML Encoding (http://stackoverflow.com/a/7124052/468718)
function htmlEncode(rawValue) {
    return String(rawValue).replace(/&/g, '&amp;').replace(/"/g, '&quot;').replace(/'/g, '\'').replace(/</g, '&lt;').replace(/>/g, '&gt;');
}

function ValidateField(controlId) {
    var control = jQuery('#' + controlId);
    var iconSpan = control.parent().find('span');

    if (control.val() != '') {
        iconSpan.attr('class', 'input-success');
        iconSpan.attr('data-original-title', '');
        iconSpan.find('i').attr('class', '');
        control.removeClass('error');

        return true;
    }
    else {
        iconSpan.attr('class', 'input-error tooltips');
        iconSpan.attr('data-original-title', control.attr('field-title') + ' is required.');
        iconSpan.find('i').attr('class', 'icon-exclamation-sign');
        control.addClass('error');

        return false;
    }
}

function ValidateEmail(controlId, isOptional) {

    var result = isOptional || ValidateField(controlId);

    if (result) {
        var control = jQuery('#' + controlId);
        var iconSpan = control.parent().find('span');
        var filter = /^(([\w-]+\.)+[\w-]+|([a-zA-Z]{1}|[\w-]{2,}))@((([0-1]?[0-9]{1,2}|25[0-5]|2[0-4][0-9])\.([0-1]?[0-9]{1,2}|25[0-5]|2[0-4][0-9])\.([0-1]?[0-9]{1,2}|25[0-5]|2[0-4][0-9])\.([0-1]?[0-9]{1,2}|25[0-5]|2[0-4][0-9])){1}|([a-zA-Z]+[\w-]+\.)+[a-zA-Z]{2,4})$/;

        if ((control.val() == '' && isOptional) || filter.test(control.val())) {
            iconSpan.attr('class', 'input-success');
            iconSpan.attr('data-original-title', '');
            iconSpan.find('i').attr('class', '');
            control.removeClass('error');

            return true;
        }
        else {
            iconSpan.attr('class', 'input-error tooltips');
            iconSpan.attr('data-original-title', 'Enter valid ' + control.attr('field-title') + '.');
            iconSpan.find('i').attr('class', 'icon-exclamation-sign');
            control.addClass('error');

            result = false;
        }
    }

    return result;
}

function ValidateAlphaNumeric(controlId, isOptional) {
    var result = isOptional || ValidateField(controlId);

    if (result) {
        var control = jQuery('#' + controlId);
        var iconSpan = control.parent().find('span');
        var filter = /^[a-zA-Z0-9]+$/;

        if ((control.val() == '' && isOptional) || filter.test(control.val())) {
            iconSpan.attr('class', 'input-success');
            iconSpan.attr('data-original-title', '');
            iconSpan.find('i').attr('class', '');
            control.removeClass('error');

            return true;
        }
        else {
            iconSpan.attr('class', 'input-error tooltips');
            iconSpan.attr('data-original-title', control.attr('field-title') + ' must contain only letters & numbers, no special characters.');
            iconSpan.find('i').attr('class', 'icon-exclamation-sign');
            control.addClass('error');

            result = false;
        }
    }

    return result;
}

function ValidateLength(controlId, noOfChars, isOptional) {
    var result = isOptional || ValidateField(controlId);

    if (result) {
        var control = jQuery('#' + controlId);
        var iconSpan = control.parent().find('span');
        var filter = new RegExp('.{' + noOfChars + '}.*');

        if ((control.val() == '' && isOptional) || filter.test(control.val())) {
            iconSpan.attr('class', 'input-success');
            iconSpan.attr('data-original-title', '');
            iconSpan.find('i').attr('class', '');
            control.removeClass('error');

            return true;
        }
        else {
            iconSpan.attr('class', 'input-error tooltips');
            iconSpan.attr('data-original-title', control.attr('field-title') + ' must be at least ' + noOfChars + ' characters.');
            iconSpan.find('i').attr('class', 'icon-exclamation-sign');
            control.addClass('error');

            result = false;
        }
    }

    return result;
}

function ValidateUserPassword(controlId, noOfChars) {
    var result = ValidateField(controlId);

    if (result) {
        result = ValidateLength(controlId, noOfChars);

        if (result) {
            result = ValidateAlphaNumeric(controlId);
        }
    }

    return result;
}

function ValidateURL(controlId, isOptional) {
    var result = isOptional || ValidateField(controlId);

    if (result) {
        var control = jQuery('#' + controlId);
        var iconSpan = control.parent().find('span');
        var filter = /(http|ftp|https):\/\/[\w-]+(\.[\w-]+)+([\w.,@?^=%&amp;:\/~+#-]*[\w@?^=%&amp;\/~+#-])?/;

        if ((control.val() == '' && isOptional) || filter.test(control.val())) {
            iconSpan.attr('class', 'input-success');
            iconSpan.attr('data-original-title', '');
            iconSpan.find('i').attr('class', '');
            control.removeClass('error');

            return true;
        }
        else {
            iconSpan.attr('class', 'input-error tooltips');
            iconSpan.attr('data-original-title', 'Enter valid ' + control.attr('field-title') + '.');
            iconSpan.find('i').attr('class', 'icon-exclamation-sign');
            control.addClass('error');

            result = false;
        }
    }

    return result;
}

function ValidateRegExp(controlId, regExp, isOptional) {
    var result = isOptional || ValidateField(controlId);

    if (result) {
        var control = jQuery('#' + controlId);
        var iconSpan = control.parent().find('span');
        var filter = new RegExp(regExp);

        if ((control.val() == '' && isOptional) || filter.test(control.val())) {
            iconSpan.attr('class', 'input-success');
            iconSpan.attr('data-original-title', '');
            iconSpan.find('i').attr('class', '');
            control.removeClass('error');

            return true;
        }
        else {
            iconSpan.attr('class', 'input-error tooltips');
            iconSpan.attr('data-original-title', 'Enter valid ' + control.attr('field-title') + '.');
            iconSpan.find('i').attr('class', 'icon-exclamation-sign');
            control.addClass('error');

            result = false;
        }
    }

    return result;
}

function hideFilterControls(hideAdd, hideDelete, hideActive, hideInactive) {

    if (hideAdd) {
        $('#divAddNew').hide();
    }

    if (hideDelete) {
        $('#divDelete').hide();
    }

    if (hideActive) {
        $('#divActive').hide();
    }

    if (hideInactive) {
        $('#divInactive').hide();
    }
}

$(function () {
    $('.focus :input:first').focus();
});

function hidePrintButton(hidePrint) {
    if (hidePrint) {
        $('#divPrint').hide();
    }
}


function notificationMessage(message, type) {
    HRN.alert(message, type);
}