﻿var HRN = function () {

    return {

        //main function to initiate the theme
        init: function () {
        },

        alert: function (message, type) {

            var id = HRN.getUniqueID();
            var closeInSeconds = 5;
            var header = "Info!";

            switch (type) {
                case "danger":
                    header = "Error!"
                    break;
                case "success":
                    header = "Success!"
                    break;
                case "info":
                    header = "Info!"
                    break;
                case "warning":
                    header = "Warning!"
                    break;
                default:
                    header = "Info!"
                    break;
            }

            var html = '<div  id="' + id + '" class="alert-box callout callout-' + type + ' fade in" ><h4>' + header + '</h4><p>' + message + '</p></div>';

            $('.alert-box').remove();

            $('.message-box').after(html);

            HRN.scrollTo($('#' + id));

            if (closeInSeconds > 0) {
                setTimeout(function () {
                    $('#' + id).remove();
                }, closeInSeconds * 1000);
            }

            return id;
        },

        scrollTo: function (el, offeset) {
            var pos = (el && el.size() > 0) ? el.offset().top : 0;

            if (el) {
                pos = pos + (offeset ? offeset : -1 * el.height());
            }

            $('html,body').animate({
                scrollTop: pos
            }, 'slow');
        },


        getUniqueID: function () {
            return 'prefx_' + Math.floor(Math.random() * (new Date()).getTime());
        },

       

        showLoader: function () {
            $('.loader').show();
        },

        hideLoader: function () {
            $('.loader').hide();
        },


    };

}();

HRN.init();