﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using HMS.Models;
using System.Web.Mvc;
using HMS.Class.BLL;
using HMS.Class.Helper;
namespace HMS.ViewModel
{
    public class PatientTestViewModel
    {
        public PatientTestViewModel()
            : this(0)
        {

        }
        public PatientTestViewModel(long? patientTestId)
        {
            this.PatientTest = new PatientTestModel();
            this.Patients = PatientBLL.GetAllActive();
            this.Consultants = UserBLL.GetAllActiveDoctor();

            this.PatientTestDetails = PatientTestBLL.GetPatientTestDetailByPatientTest(patientTestId.HasValue ? patientTestId.Value : 0);
        }
        public PatientTestModel PatientTest { get; set; }
        public List<PatientTestDetailModel> PatientTestDetails { get; set; }

        public List<PatientModel> Patients { get; set; }

        public List<UserModel> Consultants { get; set; }
        
    }

}