﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using HMS.Models;
using System.Web.Mvc;
using HMS.Class.BLL;
using HMS.Class.Helper;
namespace HMS.ViewModel
{
    public class PaymentViewModel
    {
        public PaymentViewModel()
            : this(0)
        {

        }
        public PaymentViewModel(long? paymentId)
        {
            this.Payment = new PaymentModel();
            this.Patients = PatientBLL.GetAllActive();


            this.PaymentDetails = PaymentBLL.GetPaymentDetailByPayment(paymentId.HasValue ? paymentId.Value : 0);
        }
        public PaymentModel Payment { get; set; }
        public List<PaymentDetailModel> PaymentDetails { get; set; }

        public List<PatientModel> Patients { get; set; }
        
    }

    public class InvoiceViewModel
    {
        public InvoiceViewModel()
            : this(0)
        {

        }
        public InvoiceViewModel(long? paymentId)
        {
            this.Payment = PaymentBLL.GetById(paymentId ?? 0);

            if (Payment != null)
            {
                this.Patient = PatientBLL.GetById(Payment.PatientId);
                this.PaymentDetails = PaymentBLL.GetPaymentDetailByPayment(paymentId.HasValue ? paymentId.Value : 0);
                this.Company = CompanyBLL.GetById(Payment.CompanyId);
            }
        }
        public PaymentModel Payment { get; set; }
        public List<PaymentDetailModel> PaymentDetails { get; set; }
        public PatientModel Patient { get; set; }
        public CompanyModel Company { get; set; }
    }
}